/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.id.sharedpk;

import javax.persistence.EntityManager;
import org.fest.assertions.Assertions;
import org.hibernate.ogm.backendtck.id.sharedpk.CoffeeMug;
import org.hibernate.ogm.backendtck.id.sharedpk.Lid;
import org.hibernate.ogm.utils.jpa.OgmJpaTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SharedPrimaryKeyTest
extends OgmJpaTestCase {
    private EntityManager em;

    @Before
    public void setUp() {
        this.em = this.getFactory().createEntityManager();
    }

    @After
    public void tearDown() {
        this.em.close();
    }

    @Test
    public void testSequenceIdGenerationInJTA() throws Exception {
        this.em.getTransaction().begin();
        CoffeeMug mug = new CoffeeMug();
        mug.setCapacity(568);
        Lid lid = new Lid();
        lid.setColor("blue");
        lid.setMug(mug);
        mug.setLid(lid);
        this.em.persist((Object)mug);
        this.em.getTransaction().commit();
        this.em.clear();
        this.em.getTransaction().begin();
        mug = (CoffeeMug)this.em.find(CoffeeMug.class, (Object)mug.getId());
        Assertions.assertThat((Object)mug).isNotNull();
        Assertions.assertThat((Object)mug.getLid()).isNotNull();
        Assertions.assertThat((String)mug.getLid().getId()).isEqualTo((Object)mug.getId());
        this.em.remove((Object)mug);
        this.em.getTransaction().commit();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{CoffeeMug.class, Lid.class};
    }
}

