/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.inheritance;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.fest.assertions.Assertions;
import org.hibernate.ogm.backendtck.inheritance.HeroClub;
import org.hibernate.ogm.backendtck.simpleentity.Hero;
import org.hibernate.ogm.backendtck.simpleentity.SuperHero;
import org.hibernate.ogm.utils.PackagingRule;
import org.hibernate.ogm.utils.TestHelper;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class JPAPolymorphicCollectionTest {
    @Rule
    public PackagingRule packaging = new PackagingRule("persistencexml/ogm.xml", Hero.class, SuperHero.class, HeroClub.class);
    private EntityManagerFactory emf;
    private EntityManager em;

    @Before
    public void setUp() {
        this.emf = Persistence.createEntityManagerFactory((String)"ogm", TestHelper.getDefaultTestSettings());
        this.em = this.emf.createEntityManager();
    }

    @After
    public void tearDown() {
        TestHelper.dropSchemaAndDatabase(this.emf);
        this.em.close();
        this.emf.close();
    }

    @Test
    public void testJPAPolymorphicCollection() throws Exception {
        this.em.getTransaction().begin();
        Hero h = new Hero();
        h.setName("Spartacus");
        this.em.persist((Object)h);
        SuperHero sh = new SuperHero();
        sh.setName("Batman");
        sh.setSpecialPower("Technology and samurai techniques");
        this.em.persist((Object)sh);
        HeroClub hc = new HeroClub();
        hc.setName("My hero club");
        hc.getMembers().add(h);
        hc.getMembers().add(sh);
        this.em.persist((Object)hc);
        this.em.getTransaction().commit();
        this.em.clear();
        this.em.getTransaction().begin();
        HeroClub lhc = (HeroClub)this.em.find(HeroClub.class, (Object)hc.getName());
        Assertions.assertThat((Object)lhc).isNotNull();
        Hero lh = lhc.getMembers().get(0);
        Assertions.assertThat((Object)lh).isNotNull();
        Assertions.assertThat((Object)lh).isInstanceOf(Hero.class);
        Hero lsh = lhc.getMembers().get(1);
        Assertions.assertThat((Object)lsh).isNotNull();
        Assertions.assertThat((Object)lsh).isInstanceOf(SuperHero.class);
        lhc.getMembers().clear();
        this.em.remove((Object)lh);
        this.em.remove((Object)lsh);
        this.em.remove((Object)lhc);
        this.em.getTransaction().commit();
    }
}

