/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.inheritance;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.fest.assertions.Assertions;
import org.hibernate.ogm.backendtck.simpleentity.Hero;
import org.hibernate.ogm.backendtck.simpleentity.SuperHero;
import org.hibernate.ogm.utils.PackagingRule;
import org.hibernate.ogm.utils.TestHelper;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class JPAPolymorphicFindTest {
    @Rule
    public PackagingRule packaging = new PackagingRule("persistencexml/ogm.xml", Hero.class, SuperHero.class);
    private EntityManagerFactory emf;
    private EntityManager em;

    @Before
    public void setUp() {
        this.emf = Persistence.createEntityManagerFactory((String)"ogm", TestHelper.getDefaultTestSettings());
        this.em = this.emf.createEntityManager();
    }

    @After
    public void tearDown() {
        TestHelper.dropSchemaAndDatabase(this.emf);
        this.em.close();
        this.emf.close();
    }

    @Test
    public void testJPAPolymorphicFind() throws Exception {
        this.em.getTransaction().begin();
        Hero h = new Hero();
        h.setName("Spartacus");
        this.em.persist((Object)h);
        SuperHero sh = new SuperHero();
        sh.setName("Batman");
        sh.setSpecialPower("Technology and samurai techniques");
        this.em.persist((Object)sh);
        this.em.getTransaction().commit();
        this.em.clear();
        this.em.getTransaction().begin();
        Hero lh = (Hero)this.em.find(Hero.class, (Object)h.getName());
        Assertions.assertThat((Object)lh).isNotNull();
        Assertions.assertThat((Object)lh).isInstanceOf(Hero.class);
        Hero lsh = (Hero)this.em.find(Hero.class, (Object)sh.getName());
        Assertions.assertThat((Object)lsh).isNotNull();
        Assertions.assertThat((Object)lsh).isInstanceOf(SuperHero.class);
        this.em.remove((Object)lh);
        this.em.remove((Object)lsh);
        this.em.getTransaction().commit();
    }
}

