/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.inheritance;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.fest.assertions.Assertions;
import org.hibernate.ogm.backendtck.inheritance.CommunityMember;
import org.hibernate.ogm.backendtck.inheritance.Employee;
import org.hibernate.ogm.utils.PackagingRule;
import org.hibernate.ogm.utils.TestHelper;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class JPATablePerClassFindTest {
    @Rule
    public PackagingRule packaging = new PackagingRule("persistencexml/ogm.xml", CommunityMember.class, Employee.class);
    private EntityManagerFactory emf;
    private EntityManager em;

    @Before
    public void setUp() {
        this.emf = Persistence.createEntityManagerFactory((String)"ogm", TestHelper.getDefaultTestSettings());
        this.em = this.emf.createEntityManager();
    }

    @After
    public void tearDown() {
        TestHelper.dropSchemaAndDatabase(this.emf);
        this.em.close();
        this.emf.close();
    }

    @Test
    public void testJPAPolymorphicFind() throws Exception {
        this.em.getTransaction().begin();
        CommunityMember member = new CommunityMember("Davide");
        this.em.persist((Object)member);
        Employee employee = new Employee("Alex", "EMPLOYER");
        this.em.persist((Object)employee);
        this.em.getTransaction().commit();
        this.em.clear();
        this.em.getTransaction().begin();
        CommunityMember lh = (CommunityMember)this.em.find(CommunityMember.class, (Object)member.name);
        Assertions.assertThat((Object)lh).isNotNull();
        Assertions.assertThat((Object)lh).isInstanceOf(CommunityMember.class);
        CommunityMember lsh = (CommunityMember)this.em.find(Employee.class, (Object)employee.name);
        Assertions.assertThat((Object)lsh).isNotNull();
        Assertions.assertThat((Object)lsh).isInstanceOf(Employee.class);
        Assertions.assertThat((String)employee.employer).isEqualTo((Object)employee.employer);
        this.em.remove((Object)lh);
        this.em.remove((Object)lsh);
        this.em.getTransaction().commit();
    }
}

