/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.inheritance.tableperclass.family;

import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManager;
import org.hibernate.ogm.backendtck.inheritance.tableperclass.family.Child;
import org.hibernate.ogm.backendtck.inheritance.tableperclass.family.Man;
import org.hibernate.ogm.backendtck.inheritance.tableperclass.family.Person;
import org.hibernate.ogm.backendtck.inheritance.tableperclass.family.Woman;
import org.hibernate.ogm.utils.jpa.OgmJpaTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TablePerClassInheritancePersistTest
extends OgmJpaTestCase {
    private EntityManager em;

    @Before
    public void setUp() {
        this.em = this.getFactory().createEntityManager();
    }

    @After
    public void tearDown() {
        this.em.close();
    }

    @Test
    public void testPersistEntititesWithoutErrors() {
        Man john = new Man("John");
        Woman jane = new Woman("Jane");
        Child susan = new Child("Susan");
        Child mark = new Child("Mark");
        List<Child> children = Arrays.asList(susan, mark);
        jane.setHusband(john);
        jane.setChildren(children);
        john.setWife(jane);
        john.setChildren(children);
        for (Child child : children) {
            child.setFather(john);
            child.setMother(jane);
        }
        this.persist(john, jane, susan, mark);
    }

    private void persist(Object ... entities) {
        this.em.getTransaction().begin();
        for (Object entity : entities) {
            this.em.persist(entity);
        }
        this.em.getTransaction().commit();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Child.class, Man.class, Person.class, Woman.class};
    }
}

