/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.innertypes;

import javax.persistence.EntityManager;
import org.fest.assertions.Assertions;
import org.hibernate.ogm.backendtck.innertypes.CommunityMember;
import org.hibernate.ogm.utils.jpa.OgmJpaTestCase;
import org.junit.Test;

public class InnerClassFindTest
extends OgmJpaTestCase {
    @Test
    public void testInnerClassFind() throws Exception {
        EntityManager em = this.getFactory().createEntityManager();
        em.getTransaction().begin();
        CommunityMember member = new CommunityMember("Davide");
        em.persist((Object)member);
        CommunityMember.Employee employee = new CommunityMember.Employee("Alex", "EMPLOYER");
        em.persist((Object)employee);
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        CommunityMember lh = (CommunityMember)em.find(CommunityMember.class, (Object)member.name);
        Assertions.assertThat((Object)lh).isNotNull();
        Assertions.assertThat((Object)lh).isInstanceOf(CommunityMember.class);
        CommunityMember lsh = (CommunityMember)em.find(CommunityMember.Employee.class, (Object)employee.name);
        Assertions.assertThat((Object)lsh).isNotNull();
        Assertions.assertThat((Object)lsh).isInstanceOf(CommunityMember.Employee.class);
        Assertions.assertThat((String)employee.employer).isEqualTo((Object)employee.employer);
        em.remove((Object)lh);
        em.remove((Object)lsh);
        em.getTransaction().commit();
        em.close();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{CommunityMember.class, CommunityMember.Employee.class};
    }
}

