/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import org.fest.assertions.Assertions;
import org.hibernate.ogm.backendtck.jpa.Poem;
import org.hibernate.ogm.jpa.impl.OgmEntityManager;
import org.hibernate.ogm.jpa.impl.OgmEntityManagerFactory;
import org.hibernate.ogm.utils.PackagingRule;
import org.hibernate.ogm.utils.TestHelper;
import org.hibernate.ogm.utils.jpa.OgmJpaTestCase;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JPAAPIWrappingTest
extends OgmJpaTestCase {
    @Rule
    public PackagingRule packaging = new PackagingRule("persistencexml/ogm.xml", Poem.class);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testWrappedStandalone() throws Exception {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"ogm", TestHelper.getDefaultTestSettings());
        Assertions.assertThat(emf.getClass()).isEqualTo(OgmEntityManagerFactory.class);
        EntityManager em = emf.createEntityManager();
        Assertions.assertThat(em.getClass()).isEqualTo(OgmEntityManager.class);
        em.close();
        em = emf.createEntityManager();
        Assertions.assertThat(em.getClass()).isEqualTo(OgmEntityManager.class);
        em.close();
        emf.close();
    }

    @Test
    public void testUndefinedPU() throws Exception {
        this.thrown.expect(PersistenceException.class);
        Persistence.createEntityManagerFactory((String)"does-not-exist-PU");
    }

    @Test
    public void testWrapInContainer() throws Exception {
        Assertions.assertThat(this.getFactory().getClass()).isEqualTo(OgmEntityManagerFactory.class);
        EntityManager entityManager = this.getFactory().createEntityManager();
        Assertions.assertThat(entityManager.getClass()).isEqualTo(OgmEntityManager.class);
        entityManager.close();
        entityManager = this.getFactory().createEntityManager();
        Assertions.assertThat(entityManager.getClass()).isEqualTo(OgmEntityManager.class);
        entityManager.close();
    }

    @Test
    public void testIllegalArgumentExceptionIfQueryDefinitionDoesNotExists() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        EntityManager em = this.getFactory().createEntityManager();
        em.createNamedQuery("DoesNotExistsQuery");
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Poem.class};
    }
}

