/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.transaction.TransactionManager;
import org.fest.assertions.Assertions;
import org.hibernate.ogm.backendtck.jpa.Poem;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.PackagingRule;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.hibernate.ogm.utils.TestHelper;
import org.hibernate.ogm.utils.jpa.OgmJpaTestCase;
import org.junit.Rule;
import org.junit.Test;

public class JPAJTATest
extends OgmJpaTestCase {
    @Rule
    public PackagingRule packaging = new PackagingRule("persistencexml/transaction-type-jta.xml", Poem.class);

    @Test
    @SkipByGridDialect(value={GridDialectType.MONGODB, GridDialectType.CASSANDRA, GridDialectType.INFINISPAN_REMOTE}, comment="MongoDB, Cassandra and Hot Rod tests run w/o transaction manager")
    public void testBootstrapAndCRUD() throws Exception {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"transaction-type-jta", TestHelper.getDefaultTestSettings());
        TransactionManager transactionManager = this.getTransactionManager(emf);
        transactionManager.begin();
        EntityManager em = emf.createEntityManager();
        Poem poem = new Poem();
        poem.setName("L'albatros");
        em.persist((Object)poem);
        transactionManager.commit();
        em.clear();
        transactionManager.begin();
        em.joinTransaction();
        poem = (Poem)em.find(Poem.class, (Object)poem.getId());
        Assertions.assertThat((Object)poem).isNotNull();
        Assertions.assertThat((String)poem.getName()).isEqualTo((Object)"L'albatros");
        em.remove((Object)poem);
        transactionManager.commit();
        em.close();
        TestHelper.dropSchemaAndDatabase(emf);
        emf.close();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Poem.class};
    }
}

