/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import org.fest.assertions.Assertions;
import org.hibernate.ogm.backendtck.jpa.Poem;
import org.hibernate.ogm.utils.PackagingRule;
import org.hibernate.ogm.utils.RequiresTransactionalCapabilitiesRule;
import org.hibernate.ogm.utils.TestHelper;
import org.junit.Rule;
import org.junit.Test;

public class JPAResourceLocalTest {
    @Rule
    public PackagingRule packaging = new PackagingRule("persistencexml/transaction-type-resource-local.xml", Poem.class);
    @Rule
    public RequiresTransactionalCapabilitiesRule transactions = new RequiresTransactionalCapabilitiesRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBootstrapAndCRUD() throws Exception {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"transaction-type-resource-local", TestHelper.getDefaultTestSettings());
        try {
            EntityManager em = emf.createEntityManager();
            try {
                em.getTransaction().begin();
                Poem poem = new Poem();
                poem.setName("L'albatros");
                em.persist((Object)poem);
                em.getTransaction().commit();
                em.clear();
                em.getTransaction().begin();
                Poem poem2 = new Poem();
                poem2.setName("Wazaaaaa");
                em.persist((Object)poem2);
                em.flush();
                Assertions.assertThat((long)TestHelper.getNumberOfEntities(em)).isEqualTo(2L);
                em.getTransaction().rollback();
                Assertions.assertThat((long)TestHelper.getNumberOfEntities(em)).isEqualTo(1L);
                em.getTransaction().begin();
                poem = (Poem)em.find(Poem.class, (Object)poem.getId());
                Assertions.assertThat((Object)poem).isNotNull();
                Assertions.assertThat((String)poem.getName()).isEqualTo((Object)"L'albatros");
                em.remove((Object)poem);
                poem2 = (Poem)em.find(Poem.class, (Object)poem2.getId());
                Assertions.assertThat((Object)poem2).isNull();
                em.getTransaction().commit();
            }
            finally {
                EntityTransaction transaction = em.getTransaction();
                if (transaction != null && transaction.isActive()) {
                    transaction.rollback();
                }
                em.close();
            }
        }
        finally {
            TestHelper.dropSchemaAndDatabase(emf);
            emf.close();
        }
    }
}

