/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.loader;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.fest.assertions.Assertions;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.loader.Feeling;
import org.hibernate.ogm.datastore.map.impl.MapTupleSnapshot;
import org.hibernate.ogm.loader.impl.OgmLoader;
import org.hibernate.ogm.loader.impl.OgmLoadingContext;
import org.hibernate.ogm.model.impl.DefaultEntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.utils.OgmTestCase;
import org.hibernate.ogm.utils.TestHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.junit.Test;

public class LoaderFromTupleTest
extends OgmTestCase {
    @Test
    public void testLoadingFromTuple() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Feeling feeling = new Feeling();
        feeling.setName("Moody");
        session.persist((Object)feeling);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        EntityKey key = new EntityKey((EntityKeyMetadata)new DefaultEntityKeyMetadata("Feeling", new String[]{"UUID"}), new Object[]{feeling.getUUID()});
        Map<String, Object> entityTuple = TestHelper.extractEntityTuple((Session)session, key);
        Tuple tuple = new Tuple((TupleSnapshot)new MapTupleSnapshot(entityTuple), Tuple.SnapshotType.UPDATE);
        EntityPersister persister = ((SessionFactoryImplementor)session.getSessionFactory()).getEntityPersister(Feeling.class.getName());
        OgmLoader loader = new OgmLoader(new OgmEntityPersister[]{(OgmEntityPersister)persister}, 1);
        OgmLoadingContext ogmLoadingContext = new OgmLoadingContext();
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        tuples.add(tuple);
        ogmLoadingContext.setTuples(tuples);
        List entities = loader.loadEntitiesFromTuples((SessionImplementor)session, LockOptions.NONE, ogmLoadingContext);
        Assertions.assertThat((int)entities.size()).isEqualTo(1);
        Assertions.assertThat((String)((Feeling)entities.get(0)).getName()).isEqualTo((Object)"Moody");
        transaction.commit();
        session.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Feeling.class};
    }
}

