/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.massindex;

import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.lucene.search.Query;
import org.fest.assertions.Assertions;
import org.hibernate.ogm.backendtck.id.NewsID;
import org.hibernate.ogm.backendtck.massindex.model.IndexedLabel;
import org.hibernate.ogm.backendtck.massindex.model.IndexedNews;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.hibernate.ogm.utils.jpa.GetterPersistenceUnitInfo;
import org.hibernate.ogm.utils.jpa.OgmJpaTestCase;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.junit.Test;

public class AssociationMassIndexerTest
extends OgmJpaTestCase {
    @Test
    @SkipByGridDialect(value={GridDialectType.MONGODB}, comment="Uses embedded key which is currently not supported by the db query parsers")
    public void testEntityWithAssociationMassIndexing() throws Exception {
        this.populateDatastore();
        this.purgeAll(IndexedNews.class, IndexedLabel.class);
        this.startAndWaitMassIndexing(IndexedNews.class, IndexedLabel.class);
        this.assertEntityHasBeenIndexed();
        this.assertAssociatedElementsHaveBeenIndexed();
    }

    private void populateDatastore() throws Exception {
        List<IndexedLabel> labes = Arrays.asList(new IndexedLabel("massindex"), new IndexedLabel("test"));
        IndexedNews news = new IndexedNews(new NewsID("title", "author"), "content");
        news.setLabels(labes);
        EntityManager em = this.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)news);
        em.getTransaction().commit();
        em.close();
    }

    private void assertEntityHasBeenIndexed() throws Exception {
        FullTextEntityManager fullTextEm = Search.getFullTextEntityManager((EntityManager)this.createEntityManager());
        fullTextEm.getTransaction().begin();
        QueryBuilder queryBuilder = fullTextEm.getSearchFactory().buildQueryBuilder().forEntity(IndexedNews.class).get();
        Query luceneQuery = ((TermMatchingContext)queryBuilder.keyword().wildcard().onField("newsId").ignoreFieldBridge()).matching((Object)"tit*").createQuery();
        List list = fullTextEm.createFullTextQuery(luceneQuery, new Class[0]).getResultList();
        Assertions.assertThat((List)list).hasSize(1);
        List<IndexedLabel> labels = ((IndexedNews)list.get(0)).getLabels();
        Assertions.assertThat(labels).hasSize(2);
        Assertions.assertThat((boolean)this.contains(labels, "massindex")).isTrue();
        Assertions.assertThat((boolean)this.contains(labels, "test")).isTrue();
        fullTextEm.getTransaction().commit();
        fullTextEm.close();
    }

    private void assertAssociatedElementsHaveBeenIndexed() throws Exception {
        FullTextEntityManager fullTextEm = Search.getFullTextEntityManager((EntityManager)this.createEntityManager());
        fullTextEm.getTransaction().begin();
        QueryBuilder b = fullTextEm.getSearchFactory().buildQueryBuilder().forEntity(IndexedLabel.class).get();
        Query luceneQuery = b.keyword().wildcard().onField("name").matching((Object)"tes*").createQuery();
        List labels = fullTextEm.createFullTextQuery(luceneQuery, new Class[0]).getResultList();
        Assertions.assertThat((List)labels).hasSize(1);
        Assertions.assertThat((boolean)this.contains(labels, "test")).isTrue();
        luceneQuery = b.keyword().wildcard().onField("name").matching((Object)"mas*").createQuery();
        labels = fullTextEm.createFullTextQuery(luceneQuery, new Class[0]).getResultList();
        Assertions.assertThat((List)labels).hasSize(1);
        Assertions.assertThat((boolean)this.contains(labels, "massindex")).isTrue();
        fullTextEm.getTransaction().commit();
        fullTextEm.close();
    }

    private boolean contains(List<IndexedLabel> list, String label) {
        for (IndexedLabel indexedLabel : list) {
            if (!indexedLabel.getName().equals(label)) continue;
            return true;
        }
        return false;
    }

    private EntityManager createEntityManager() {
        return this.getFactory().createEntityManager();
    }

    private void startAndWaitMassIndexing(Class<?> ... entityTypes) throws InterruptedException {
        FullTextEntityManager fullTextEm = Search.getFullTextEntityManager((EntityManager)this.createEntityManager());
        fullTextEm.createIndexer((Class[])entityTypes).purgeAllOnStart(true).startAndWait();
        int numDocs = fullTextEm.getSearchFactory().getIndexReaderAccessor().open((Class[])entityTypes).numDocs();
        fullTextEm.close();
        Assertions.assertThat((int)numDocs).isGreaterThan(0);
    }

    private void purgeAll(Class<?> ... entityTypes) throws Exception {
        FullTextEntityManager fullTextEm = Search.getFullTextEntityManager((EntityManager)this.createEntityManager());
        for (Class<?> entityType : entityTypes) {
            fullTextEm.purgeAll(entityType);
            fullTextEm.flushToIndexes();
        }
        int numDocs = fullTextEm.getSearchFactory().getIndexReaderAccessor().open((Class[])entityTypes).numDocs();
        fullTextEm.close();
        Assertions.assertThat((int)numDocs).isEqualTo(0);
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{IndexedNews.class, IndexedLabel.class};
    }

    @Override
    protected void configure(GetterPersistenceUnitInfo info) {
        super.configure(info);
        info.getProperties().setProperty("hibernate.search.default.directory_provider", "ram");
        info.getProperties().setProperty("hibernate.ogm.infinispan.configuration_resourcename", "infinispan-dist.xml");
    }
}

