/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.massindex;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.hsearch.Insurance;
import org.hibernate.ogm.backendtck.id.NewsID;
import org.hibernate.ogm.backendtck.massindex.model.IndexedLabel;
import org.hibernate.ogm.backendtck.massindex.model.IndexedNews;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.OgmTestCase;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.junit.Test;

public class SimpleEntityMassIndexingTest
extends OgmTestCase {
    @Test
    public void testSimpleEntityMassIndexing() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Insurance insurance = new Insurance();
        insurance.setName("Insurance Corporation");
        session.persist((Object)insurance);
        transaction.commit();
        session.clear();
        session.close();
        this.purgeAll(Insurance.class);
        this.startAndWaitMassIndexing(Insurance.class);
        session = Search.getFullTextSession((Session)this.openSession());
        QueryBuilder queryBuilder = session.getSearchFactory().buildQueryBuilder().forEntity(Insurance.class).get();
        Query luceneQuery = queryBuilder.keyword().wildcard().onField("name").matching((Object)"ins*").createQuery();
        Transaction transaction2 = session.beginTransaction();
        List list = session.createFullTextQuery(luceneQuery, new Class[0]).list();
        Assertions.assertThat((List)list).hasSize(1);
        Assertions.assertThat((String)((Insurance)list.get(0)).getName()).isEqualTo((Object)"Insurance Corporation");
        transaction2.commit();
        session.clear();
        session.close();
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.MONGODB}, comment="Uses embedded key which is currently not supported by the db query parsers")
    public void testEntityWithCompositeIdMassIndexing() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        IndexedNews news = new IndexedNews(new NewsID("title", "author"), "content");
        session.persist((Object)news);
        transaction.commit();
        session.clear();
        session.close();
        this.purgeAll(IndexedNews.class);
        this.startAndWaitMassIndexing(IndexedNews.class);
        session = Search.getFullTextSession((Session)this.openSession());
        QueryBuilder queryBuilder = session.getSearchFactory().buildQueryBuilder().forEntity(IndexedNews.class).get();
        Query luceneQuery = ((TermMatchingContext)queryBuilder.keyword().wildcard().onField("newsId").ignoreFieldBridge()).matching((Object)"tit*").createQuery();
        Transaction transaction2 = session.beginTransaction();
        List list = session.createFullTextQuery(luceneQuery, new Class[0]).list();
        Assertions.assertThat((List)list).hasSize(1);
        Assertions.assertThat((String)((IndexedNews)list.get(0)).getContent()).isEqualTo((Object)"content");
        Assertions.assertThat((String)((IndexedNews)list.get(0)).getNewsId().getTitle()).isEqualTo((Object)"title");
        Assertions.assertThat((String)((IndexedNews)list.get(0)).getNewsId().getAuthor()).isEqualTo((Object)"author");
        transaction2.commit();
        session.clear();
        session.close();
    }

    private void startAndWaitMassIndexing(Class<?> entityType) throws InterruptedException, IOException {
        int numDocs;
        FullTextSession session = Search.getFullTextSession((Session)this.openSession());
        session.createIndexer(new Class[]{entityType}).purgeAllOnStart(true).startAndWait();
        try (IndexReader indexReader = session.getSearchFactory().getIndexReaderAccessor().open(new Class[]{entityType});){
            numDocs = indexReader.numDocs();
        }
        Assertions.assertThat((int)numDocs).isGreaterThan(0);
    }

    private void purgeAll(Class<?> entityType) throws IOException {
        int numDocs;
        FullTextSession session = Search.getFullTextSession((Session)this.openSession());
        session.purgeAll(entityType);
        session.flushToIndexes();
        try (IndexReader indexReader = session.getSearchFactory().getIndexReaderAccessor().open(new Class[]{entityType});){
            numDocs = indexReader.numDocs();
        }
        session.close();
        Assertions.assertThat((int)numDocs).isEqualTo(0);
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Insurance.class, IndexedNews.class, IndexedLabel.class};
    }

    @Override
    protected void configure(Map<String, Object> settings) {
        settings.put("hibernate.search.default.directory_provider", "ram");
        settings.put("hibernate.ogm.infinispan.configuration_resourcename", "infinispan-dist.xml");
    }
}

