/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.massindex.model;

import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToMany;
import org.hibernate.ogm.backendtck.id.NewsID;
import org.hibernate.ogm.backendtck.massindex.model.IndexedLabel;
import org.hibernate.ogm.backendtck.massindex.model.NewsIdFieldBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;

@Entity
@Indexed
public class IndexedNews {
    @DocumentId
    @EmbeddedId
    @FieldBridge(impl=NewsIdFieldBridge.class)
    private NewsID newsId;
    private String content;
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumns(value={@JoinColumn(name="news_topic_fk", referencedColumnName="newsid.title", nullable=false), @JoinColumn(name="news_author_fk", referencedColumnName="newsid.author", nullable=false)})
    private List<IndexedLabel> labels;

    public IndexedNews() {
    }

    public IndexedNews(NewsID newId, String content) {
        this.newsId = newId;
        this.content = content;
    }

    public NewsID getNewsId() {
        return this.newsId;
    }

    public void setNewsId(NewsID newId) {
        this.newsId = newId;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public List<IndexedLabel> getLabels() {
        return this.labels;
    }

    public void setLabels(List<IndexedLabel> labels) {
        this.labels = labels;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
        result = 31 * result + (this.newsId == null ? 0 : this.newsId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexedNews other = (IndexedNews)obj;
        if (this.content == null ? other.content != null : !this.content.equals(other.content)) {
            return false;
        }
        return !(this.newsId == null ? other.newsId != null : !this.newsId.equals(other.newsId));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IndexedNews [newsId=");
        builder.append(this.newsId);
        builder.append(", content=");
        builder.append(this.content);
        builder.append(", labels=");
        builder.append(this.labels);
        builder.append("]");
        return builder.toString();
    }
}

