/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.optimisticlocking;

import java.io.Serializable;
import java.util.Map;
import org.fest.assertions.Assertions;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.optimisticlocking.Galaxy;
import org.hibernate.ogm.backendtck.optimisticlocking.Star;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.dialect.impl.ForwardingGridDialect;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.OgmTestCase;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.hibernate.ogm.utils.TestHelper;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@SkipByGridDialect(value={GridDialectType.CASSANDRA, GridDialectType.INFINISPAN_REMOTE}, comment="list - bag semantics unsupported (no primary key)")
public class OptimisticLockingExtraTest
extends OgmTestCase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void updateToEmbeddedCollectionCausesVersionToBeIncreased() throws Throwable {
        Galaxy galaxy = this.persistGalaxy();
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Galaxy entity = (Galaxy)session.get(Galaxy.class, (Serializable)((Object)galaxy.getId()));
        entity.getStars().add(new Star("Algol"));
        transaction.commit();
        session.clear();
        session = this.openSession();
        transaction = session.beginTransaction();
        entity = (Galaxy)session.get(Galaxy.class, (Serializable)((Object)galaxy.getId()));
        Assertions.assertThat((int)entity.getVersion()).isEqualTo(1);
        Assertions.assertThat(entity.getStars()).hasSize(3);
        transaction.commit();
        session.close();
    }

    private Galaxy persistGalaxy() {
        OgmSession session = this.openSession();
        session.beginTransaction();
        Galaxy milkyWay = new Galaxy("galaxy-1", "Milky Way", new Star("Sun"), new Star("Alpha Centauri"));
        session.persist((Object)milkyWay);
        session.getTransaction().commit();
        session.close();
        return milkyWay;
    }

    @Override
    protected void configure(Map<String, Object> settings) {
        settings.put("hibernate.ogm.datastore.grid_dialect", TestDialect.class);
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Galaxy.class};
    }

    public static class TestDialect
    extends ForwardingGridDialect<Serializable> {
        public TestDialect(DatastoreProvider provider) {
            super(TestHelper.getCurrentGridDialect(provider));
        }

        public boolean updateTupleWithOptimisticLock(EntityKey entityKey, Tuple oldVersion, Tuple tuple, TupleContext tupleContext) {
            if (Thread.currentThread().getName().equals("ogm-test-thread-0")) {
                this.waitALittleBit();
            }
            return super.updateTupleWithOptimisticLock(entityKey, oldVersion, tuple, tupleContext);
        }

        public boolean removeTupleWithOptimisticLock(EntityKey entityKey, Tuple oldVersion, TupleContext tupleContext) {
            if (Thread.currentThread().getName().equals("ogm-test-thread-0")) {
                this.waitALittleBit();
            }
            return super.removeTupleWithOptimisticLock(entityKey, oldVersion, tupleContext);
        }

        private void waitALittleBit() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

