/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.optimisticlocking;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.hamcrest.CoreMatchers;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.optimisticlocking.Nameable;
import org.hibernate.ogm.backendtck.optimisticlocking.Planet;
import org.hibernate.ogm.backendtck.optimisticlocking.Pulsar;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.dialect.impl.ForwardingGridDialect;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.OgmTestCase;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.hibernate.ogm.utils.TestHelper;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class OptimisticLockingTest
extends OgmTestCase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private ThreadFactory threadFactory;
    private final CountDownLatch deleteLatch = new CountDownLatch(2);

    @Before
    public void setupThreadFactory() {
        this.threadFactory = new ThreadFactoryBuilder().setNameFormat("ogm-test-thread-%d").build();
    }

    @After
    public void cleanUp() {
        this.removePlanet();
        this.removePulsar();
    }

    @Test
    public void updatingEntityUsingOldVersionCausesException() throws Throwable {
        this.thrown.expect(StaleObjectStateException.class);
        this.persistPlanet();
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Planet entity = (Planet)session.get(Planet.class, (Serializable)((Object)"planet-1"));
        entity.setName("Uranus");
        Future<?> future1 = this.updateInSeparateThread(Planet.class, "planet-1", "Mars", LatchAction.IGNORE);
        future1.get();
        this.commitTransactionAndPropagateExceptions((Session)session, transaction);
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.HASHMAP, GridDialectType.INFINISPAN, GridDialectType.INFINISPAN_REMOTE, GridDialectType.EHCACHE, GridDialectType.NEO4J_EMBEDDED, GridDialectType.NEO4J_REMOTE, GridDialectType.COUCHDB, GridDialectType.CASSANDRA, GridDialectType.REDIS_JSON, GridDialectType.REDIS_HASH}, comment="Note that CouchDB has its own optimistic locking scheme, handled by the dialect itself.")
    public void updatingEntityUsingOldVersionCausesExceptionUsingAtomicFindAndUpdate() throws Throwable {
        this.thrown.expectCause(CoreMatchers.isA(StaleObjectStateException.class));
        this.persistPlanet();
        Future<?> future1 = this.updateInSeparateThread(Planet.class, "planet-1", "Mars", LatchAction.DECREASE_AND_WAIT);
        Future<?> future2 = this.updateInSeparateThread(Planet.class, "planet-1", "Uranus", LatchAction.DECREASE_AND_WAIT);
        future2.get();
        future1.get();
    }

    @Test
    public void deletingEntityUsingOldVersionCausesException() throws Throwable {
        this.thrown.expect(StaleObjectStateException.class);
        this.persistPlanet();
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Planet entity = (Planet)session.get(Planet.class, (Serializable)((Object)"planet-1"));
        session.delete((Object)entity);
        Future<?> future1 = this.updateInSeparateThread(Planet.class, "planet-1", "Mars", LatchAction.IGNORE);
        future1.get();
        this.commitTransactionAndPropagateExceptions((Session)session, transaction);
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.HASHMAP, GridDialectType.INFINISPAN, GridDialectType.INFINISPAN_REMOTE, GridDialectType.EHCACHE, GridDialectType.NEO4J_EMBEDDED, GridDialectType.NEO4J_REMOTE, GridDialectType.COUCHDB, GridDialectType.CASSANDRA, GridDialectType.REDIS_JSON, GridDialectType.REDIS_HASH}, comment="Note that CouchDB has its own optimistic locking scheme, handled by the dialect itself.")
    public void deletingEntityUsingOldVersionCausesExceptionUsingAtomicFindAndDelete() throws Throwable {
        this.thrown.expectCause(CoreMatchers.isA(StaleObjectStateException.class));
        this.persistPlanet();
        Future<?> future1 = this.removePlanetInSeparateThread();
        Future<?> future2 = this.updateInSeparateThread(Planet.class, "planet-1", "Uranus", LatchAction.DECREASE_AND_WAIT);
        future2.get();
        future1.get();
    }

    @Test
    public void updatingEntityUsingOldEntityStateCausesException() throws Throwable {
        this.thrown.expect(StaleObjectStateException.class);
        this.persistPulsar();
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Pulsar entity = (Pulsar)session.get(Pulsar.class, (Serializable)((Object)"pulsar-1"));
        entity.setName("PSR J0537-6910");
        Future<?> future1 = this.updateInSeparateThread(Pulsar.class, "pulsar-1", "PSR B1257+12", LatchAction.IGNORE);
        future1.get();
        this.commitTransactionAndPropagateExceptions((Session)session, transaction);
    }

    @Test
    public void deletingEntityUsingOldEntityStateCausesException() throws Throwable {
        this.thrown.expect(StaleObjectStateException.class);
        this.persistPulsar();
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Pulsar entity = (Pulsar)session.get(Pulsar.class, (Serializable)((Object)"pulsar-1"));
        session.delete((Object)entity);
        Future<?> future1 = this.updateInSeparateThread(Pulsar.class, "pulsar-1", "PSR B1257+12", LatchAction.IGNORE);
        future1.get();
        this.commitTransactionAndPropagateExceptions((Session)session, transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mergingEntityUsingOldVersionCausesException() throws Throwable {
        this.thrown.expect(StaleObjectStateException.class);
        this.persistPlanet();
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Planet entity = (Planet)session.get(Planet.class, (Serializable)((Object)"planet-1"));
        this.commitTransactionAndPropagateExceptions((Session)session, transaction);
        Future<?> future1 = this.updateInSeparateThread(Planet.class, "planet-1", "Mars", LatchAction.IGNORE);
        future1.get();
        session = this.openSession();
        transaction = session.beginTransaction();
        try {
            entity = (Planet)session.merge((Object)entity);
        }
        finally {
            this.commitTransactionAndPropagateExceptions((Session)session, transaction);
        }
    }

    private Future<?> updateInSeparateThread(final Class<? extends Nameable> type, final String id, final String newName, final LatchAction latchAction) throws Exception {
        return Executors.newSingleThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                OgmSession session = OptimisticLockingTest.this.openSession();
                Transaction transaction = session.beginTransaction();
                Nameable entity = (Nameable)session.get(type, (Serializable)((Object)id));
                entity.setName(newName);
                if (latchAction == LatchAction.DECREASE_AND_WAIT) {
                    OptimisticLockingTest.this.countDownAndAwaitLatch();
                }
                transaction.commit();
                session.close();
            }
        });
    }

    private Future<?> removePlanetInSeparateThread() throws Exception {
        return Executors.newSingleThreadExecutor(this.threadFactory).submit(new Runnable(){

            @Override
            public void run() {
                OgmSession session = OptimisticLockingTest.this.openSession();
                Transaction transaction = session.beginTransaction();
                Planet entity = (Planet)session.get(Planet.class, (Serializable)((Object)"planet-1"));
                OptimisticLockingTest.this.countDownAndAwaitLatch();
                session.delete((Object)entity);
                transaction.commit();
                session.close();
            }
        });
    }

    private Planet persistPlanet() {
        OgmSession session = this.openSession();
        session.beginTransaction();
        Planet planet = new Planet("planet-1", "Pluto");
        session.persist((Object)planet);
        session.getTransaction().commit();
        session.close();
        return planet;
    }

    public void removePlanet() {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Planet entity = (Planet)session.get(Planet.class, (Serializable)((Object)"planet-1"));
        if (entity != null) {
            session.delete((Object)entity);
        }
        transaction.commit();
    }

    private Pulsar persistPulsar() {
        OgmSession session = this.openSession();
        session.beginTransaction();
        Pulsar pulsar = new Pulsar("pulsar-1", "PSR 1919+21", 1.33);
        session.persist((Object)pulsar);
        session.getTransaction().commit();
        session.close();
        return pulsar;
    }

    public void removePulsar() {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Pulsar entity = (Pulsar)session.get(Pulsar.class, (Serializable)((Object)"pulsar-1"));
        if (entity != null) {
            session.delete((Object)entity);
        }
        transaction.commit();
    }

    private void commitTransactionAndPropagateExceptions(Session session, Transaction transaction) throws Exception {
        try {
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.getStatus() == TransactionStatus.ACTIVE) {
                transaction.rollback();
            }
            throw e;
        }
        finally {
            session.close();
        }
    }

    private void countDownAndAwaitLatch() {
        this.deleteLatch.countDown();
        try {
            this.deleteLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void configure(Map<String, Object> settings) {
        settings.put("hibernate.ogm.datastore.grid_dialect", TestDialect.class);
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Planet.class, Pulsar.class};
    }

    public static class TestDialect
    extends ForwardingGridDialect<Serializable> {
        public TestDialect(DatastoreProvider provider) {
            super(TestHelper.getCurrentGridDialect(provider));
        }

        public boolean updateTupleWithOptimisticLock(EntityKey entityKey, Tuple oldVersion, Tuple tuple, TupleContext tupleContext) {
            if (Thread.currentThread().getName().equals("ogm-test-thread-0")) {
                this.waitALittleBit();
            }
            return super.updateTupleWithOptimisticLock(entityKey, oldVersion, tuple, tupleContext);
        }

        public boolean removeTupleWithOptimisticLock(EntityKey entityKey, Tuple oldVersion, TupleContext tupleContext) {
            if (Thread.currentThread().getName().equals("ogm-test-thread-0")) {
                this.waitALittleBit();
            }
            return super.removeTupleWithOptimisticLock(entityKey, oldVersion, tupleContext);
        }

        private void waitALittleBit() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static enum LatchAction {
        DECREASE_AND_WAIT,
        IGNORE;

    }
}

