/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.perf;

import java.util.Date;
import java.util.Random;
import javax.persistence.EntityManager;
import org.fest.assertions.Assertions;
import org.hibernate.ogm.backendtck.perf.Author;
import org.hibernate.ogm.backendtck.perf.Blog;
import org.hibernate.ogm.backendtck.perf.BlogEntry;
import org.hibernate.ogm.utils.jpa.SingleJpaTestCase;
import org.junit.Ignore;

@Ignore
public class PerfTest
extends SingleJpaTestCase {
    private static Random rand = new Random();

    public static void main(String[] args) {
        PerfTest perfTest = new PerfTest();
        try {
            perfTest.createFactory();
            perfTest.testCollectionAssociations();
            perfTest.closeFactory();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void testCollectionAssociations() throws Exception {
        System.out.printf("Warming up\n", new Object[0]);
        EntityManager em = this.getFactory().createEntityManager();
        em.getTransaction().begin();
        int nbrOfAuthors = 5000;
        if (nbrOfAuthors >= 200) {
            for (int j = 0; j < nbrOfAuthors / 200; ++j) {
                this.save200AuthorsAndCommit(em, 200);
                this.save200BlogsAndCommit(em, 200);
            }
        } else {
            this.save200AuthorsAndCommit(em, nbrOfAuthors);
            this.save200BlogsAndCommit(em, nbrOfAuthors);
        }
        em.getTransaction().commit();
        int nbrOfBlogEntries = 350000;
        System.out.printf("Warm up period done\nSaving %s Blog entries\n", nbrOfBlogEntries);
        long start = System.nanoTime();
        em.getTransaction().begin();
        em.joinTransaction();
        for (int j = 0; j < nbrOfBlogEntries / 200; ++j) {
            this.save200BlogEntriesAndCommit(em, nbrOfAuthors, true);
        }
        em.getTransaction().commit();
        System.out.printf("Writing %s took %sms ie %sns/entry\n", nbrOfBlogEntries, (System.nanoTime() - start) / 1000000L, (System.nanoTime() - start) / (long)nbrOfBlogEntries);
        System.out.printf("Collection ratio %s entries per collection\n", nbrOfBlogEntries / nbrOfAuthors);
        em.getTransaction().begin();
        em.joinTransaction();
        em = this.getFactory().createEntityManager();
        int nbr_of_reads = 100000;
        start = System.nanoTime();
        for (int i = 0; i < nbr_of_reads; ++i) {
            int primaryKey = rand.nextInt(nbrOfBlogEntries - 1) + 1;
            BlogEntry blogEntry = (BlogEntry)em.find(BlogEntry.class, (Object)primaryKey);
            Assertions.assertThat((String)blogEntry.getContent()).isNotEmpty();
            Assertions.assertThat((Long)blogEntry.getId()).isEqualTo((long)primaryKey);
            Assertions.assertThat((Object)blogEntry.getAuthor()).isNotNull();
            Assertions.assertThat((String)blogEntry.getAuthor().getFname()).isNotEmpty();
            Assertions.assertThat((String)blogEntry.getBlog().getTitle()).isNotEmpty();
        }
        System.out.printf("Reading %s took %sms ie %sns/entry\n", nbr_of_reads, (System.nanoTime() - start) / 1000000L, (System.nanoTime() - start) / (long)nbr_of_reads);
        em.getTransaction().commit();
        em.clear();
        start = System.nanoTime();
        int blogReads = nbrOfAuthors * 10;
        if (blogReads > 10000) {
            blogReads = 10000;
        }
        for (int i = 0; i < blogReads; ++i) {
            em.getTransaction().begin();
            em.joinTransaction();
            int primaryKey = this.randId(nbrOfAuthors);
            Blog blog = (Blog)em.find(Blog.class, (Object)primaryKey);
            Assertions.assertThat((String)blog.getTitle()).isNotEmpty();
            Assertions.assertThat((Integer)blog.getId()).isEqualTo(primaryKey);
            Assertions.assertThat(blog.getEntries()).isNotNull();
            if (blog.getEntries().size() < nbrOfBlogEntries / nbrOfAuthors / 10) {
                System.out.printf("Small number of entries in this collection %s\n", blog.getEntries().size());
            }
            em.clear();
            em.getTransaction().commit();
        }
        System.out.printf("Reading from blog %s times took %sms ie %sns/entry\n", blogReads, (System.nanoTime() - start) / 1000000L, (System.nanoTime() - start) / (long)blogReads);
        em.close();
    }

    public void testManyToOneAssociations() throws Exception {
        System.out.printf("Warming up\n", new Object[0]);
        EntityManager em = this.getFactory().createEntityManager();
        em.getTransaction().begin();
        int nbrOfAuthors = 50000;
        for (int j = 0; j < nbrOfAuthors / 200; ++j) {
            this.save200AuthorsAndCommit(em, 200);
        }
        em.getTransaction().commit();
        int nbrOfBlogEntries = 350000;
        System.out.printf("Warm up period done\nSaving %s Blog entries\n", nbrOfBlogEntries);
        long start = System.nanoTime();
        em.getTransaction().begin();
        em.joinTransaction();
        for (int j = 0; j < nbrOfBlogEntries / 200; ++j) {
            this.save200BlogEntriesAndCommit(em, nbrOfAuthors, false);
        }
        em.getTransaction().commit();
        System.out.printf("Writing %s took %sms ie %sns/entry\n", nbrOfBlogEntries, (System.nanoTime() - start) / 1000000L, (System.nanoTime() - start) / (long)nbrOfBlogEntries);
        em.getTransaction().begin();
        em.joinTransaction();
        em = this.getFactory().createEntityManager();
        int nbr_of_reads = 100000;
        start = System.nanoTime();
        for (int i = 0; i < nbr_of_reads; ++i) {
            int primaryKey = rand.nextInt(nbrOfBlogEntries - 1) + 1;
            BlogEntry blog = (BlogEntry)em.find(BlogEntry.class, (Object)primaryKey);
            Assertions.assertThat((String)blog.getContent()).isNotEmpty();
            Assertions.assertThat((Long)blog.getId()).isEqualTo((long)primaryKey);
            Assertions.assertThat((Object)blog.getAuthor()).isNotNull();
            Assertions.assertThat((String)blog.getAuthor().getFname()).isNotEmpty();
        }
        System.out.printf("Reading %s took %sms ie %sns/entry\n", nbr_of_reads, (System.nanoTime() - start) / 1000000L, (System.nanoTime() - start) / (long)nbr_of_reads);
        em.close();
        em.getTransaction().commit();
    }

    public void testSimpleEntityInserts() throws Exception {
        EntityManager em = this.getFactory().createEntityManager();
        em.getTransaction().begin();
        int authors = 2000000;
        System.out.printf("Warming up\n", new Object[0]);
        for (int j = 0; j < 200; ++j) {
            this.save200AuthorsAndCommit(em, 200);
        }
        System.out.printf("Warm up period done\nSaving %s entities\n", authors);
        long start = System.nanoTime();
        for (int j = 0; j < authors / 200; ++j) {
            this.save200AuthorsAndCommit(em, 200);
        }
        System.out.printf("Saving %s took %sms ie %sns/entry\n", authors, (System.nanoTime() - start) / 1000000L, (System.nanoTime() - start) / (long)authors);
        em.close();
        em.getTransaction().commit();
        em.getTransaction().begin();
        em = this.getFactory().createEntityManager();
        int nbr_of_reads = 100000;
        start = System.nanoTime();
        for (int i = 0; i < nbr_of_reads; ++i) {
            int primaryKey = rand.nextInt(authors - 1) + 1;
            Author author = (Author)em.find(Author.class, (Object)primaryKey);
            if (author == null) {
                System.out.printf("Cannot find author %s, %sth loop\n", primaryKey, i);
                continue;
            }
            Assertions.assertThat((String)author.getBio()).isNotEmpty();
            Assertions.assertThat((int)author.getA_id()).isEqualTo(primaryKey);
        }
        System.out.printf("Reading %s took %sms ie %sns/entry\n", nbr_of_reads, (System.nanoTime() - start) / 1000000L, (System.nanoTime() - start) / (long)nbr_of_reads);
        em.close();
        em.getTransaction().commit();
    }

    private void save200AuthorsAndCommit(EntityManager em, int nbrOfAuthors) throws Exception {
        for (int i = 0; i < nbrOfAuthors; ++i) {
            Author author = new Author();
            author.setBio("This is a decent size bio made of " + rand.nextDouble() + " stuffs");
            author.setDob(new Date());
            author.setFname("Emmanuel " + rand.nextInt());
            author.setLname("Bernard " + rand.nextInt());
            author.setMname("" + rand.nextInt(26));
            em.persist((Object)author);
        }
        em.flush();
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        em.joinTransaction();
    }

    private void save200BlogsAndCommit(EntityManager em, int nbrFfBlogs) throws Exception {
        for (int i = 0; i < nbrFfBlogs; ++i) {
            Blog blog = new Blog();
            blog.setTitle("My life in a blog" + rand.nextDouble());
            blog.setDescription("I will describe what's happening in my life and ho things are going " + rand.nextDouble());
            em.persist((Object)blog);
        }
        em.flush();
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        em.joinTransaction();
    }

    private void save200BlogEntriesAndCommit(EntityManager em, int nbrOfAuthors, boolean alsoAddBlog) throws Exception {
        for (int i = 0; i < 200; ++i) {
            BlogEntry blogEntry = new BlogEntry();
            blogEntry.setTitle("This is a blog of " + rand.nextDouble());
            blogEntry.setContent("Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas bibendum risus commodo purus pellentesque quis venenatis enim tincidunt. Maecenas at nisl in nunc eleifend rutrum eu sit amet urna. Nulla dui diam, mollis a facilisis nec, iaculis feugiat lectus. Donec egestas, dui id facilisis euismod, lorem dui ornare est, vel feugiat ipsum odio et augue. Phasellus laoreet quam et augue hendrerit interdum cursus urna sodales. Cras eleifend mollis pharetra. Donec lectus sapien, ultricies eu fermentum sed, tempor nec odio.\n\n" + rand.nextDouble() + "Proin ullamcorper bibendum leo, ut luctus turpis sodales nec. Sed diam augue, malesuada quis dapibus eu, convallis et ligula. Duis eget vehicula quam. Quisque id mauris non nisl mattis tempus a non augue. In ut purus orci, vitae eleifend ipsum. Praesent convallis fringilla massa non tincidunt. Duis eget erat venenatis purus iaculis accumsan eu et mauris. Mauris id risus et erat consequat eleifend vitae in nisl. Integer consequat, velit vel dapibus posuere, nisl magna semper tellus, ut commodo felis purus at ipsum. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.\n\nUt sodales purus sit amet sapien semper sagittis. Duis aliquam tempus dictum. Cras suscipit ullamcorper cursus. Nam mollis lacinia aliquam. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Maecenas quis risus est, sit amet iaculis sapien. Ut nibh sapien, ornare ac mattis et, scelerisque eu leo. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.\n\nNulla in elit in felis viverra venenatis id a ligula. Nunc nec odio felis, vel ultricies metus. Morbi placerat porta elementum. Vestibulum a lacinia lectus. Nunc mauris nunc, luctus non mattis ac, venenatis vitae nulla. Sed risus est, imperdiet vitae molestie in, ullamcorper nec urna. Donec eu risus sem. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla.");
            int randId = this.randId(nbrOfAuthors);
            blogEntry.setAuthor((Author)em.find(Author.class, (Object)randId));
            if (alsoAddBlog) {
                randId = this.randId(nbrOfAuthors);
                blogEntry.setBlog((Blog)em.find(Blog.class, (Object)randId));
            }
            em.persist((Object)blogEntry);
            em.getTransaction().commit();
            em.clear();
            em.getTransaction().begin();
            em.joinTransaction();
        }
    }

    private int randId(int nbrOfAuthors) {
        int randId = nbrOfAuthors > 1 ? rand.nextInt(nbrOfAuthors - 1) + 1 : 1;
        return randId;
    }

    @Override
    public Class<?>[] getEntities() {
        return new Class[]{Author.class, BlogEntry.class, Blog.class};
    }
}

