/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.queries;

import java.util.List;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.ogm.backendtck.id.Label;
import org.hibernate.ogm.backendtck.id.News;
import org.hibernate.ogm.backendtck.id.NewsID;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.OgmTestCase;
import org.hibernate.ogm.utils.SessionHelper;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.hibernate.ogm.utils.TestSessionFactory;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@SkipByGridDialect(value={GridDialectType.CASSANDRA, GridDialectType.COUCHDB, GridDialectType.EHCACHE, GridDialectType.HASHMAP, GridDialectType.INFINISPAN, GridDialectType.INFINISPAN_REMOTE, GridDialectType.REDIS_JSON, GridDialectType.REDIS_HASH}, comment="Hibernate Search does not store properties of the @EmbeddedId by default in the index, it requires the use of @FieldBridge.It is also not sufficient to add a custom field bridge because the properties of the embedded id won't be recognized as properties of the entity.There is a JIRA to keep track of this: OGM-849")
public class CompositeIdQueriesTest
extends OgmTestCase {
    @TestSessionFactory
    public static SessionFactory sessions;
    private static final String author = "Guillaume";
    private static final String titleOGM = "How to use Hibernate OGM ?";
    private static final String titleAboutJUG = "What is a JUG ?";
    private static final String titleCountJUG = "There are more than 20 JUGs in France";
    private static final String contentOGM = "Simple, just like ORM but with a NoSQL database";
    private static final String contentAboutJUG = "JUG means Java User Group";
    private static final String contentCountJUG = "Great! Congratulations folks";
    private static final News aboutJUG;
    private static final News ogmHowTo;
    private static final News countJUG;
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private Session session;
    private Transaction tx;

    @BeforeClass
    public static void insertTestEntities() throws Exception {
        SessionHelper.persist(sessions, ogmHowTo, aboutJUG, countJUG);
    }

    @Test
    public void testQueryWithFileterOnAttribute() throws Exception {
        News result = (News)this.session.createQuery("FROM News n WHERE n.newsId.title = '" + ogmHowTo.getNewsId().getTitle() + "'").uniqueResult();
        Assertions.assertThat((Object)result).isEqualTo((Object)ogmHowTo);
    }

    @Test
    public void testSingleAttributeProjection() throws Exception {
        String result = (String)this.session.createQuery("SELECT n.newsId.title FROM News n WHERE n.newsId.title = '" + ogmHowTo.getNewsId().getTitle() + "'").uniqueResult();
        Assertions.assertThat((String)result).isEqualTo((Object)ogmHowTo.getNewsId().getTitle());
    }

    @Test
    public void testProjections() throws Exception {
        List<SessionHelper.ProjectionResult> result = SessionHelper.asProjectionResults(this.session, "SELECT n.newsId.title, n.newsId.author, n.content FROM News n WHERE n.newsId.title = '" + ogmHowTo.getNewsId().getTitle() + "'");
        Assertions.assertThat(result).containsExactly(new Object[]{new SessionHelper.ProjectionResult(ogmHowTo.getNewsId().getTitle(), ogmHowTo.getNewsId().getAuthor(), ogmHowTo.getContent())});
    }

    @Before
    public void createSession() {
        this.closeSession();
        this.session = sessions.openSession();
        this.tx = this.session.beginTransaction();
    }

    @After
    public void closeSession() {
        if (this.tx != null && this.tx.getStatus() == TransactionStatus.ACTIVE) {
            this.tx.commit();
            this.tx = null;
        }
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    @AfterClass
    public static void removeTestEntities() throws Exception {
        SessionHelper.delete(sessions, News.class, ogmHowTo.getNewsId(), aboutJUG.getNewsId(), countJUG.getNewsId());
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{News.class, Label.class};
    }

    static {
        aboutJUG = new News(new NewsID(titleAboutJUG, author), contentAboutJUG, null);
        ogmHowTo = new News(new NewsID(titleOGM, author), contentOGM, null);
        countJUG = new News(new NewsID(titleCountJUG, author), contentCountJUG, null);
    }
}

