/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.queries;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.NamedQuery;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.Store;

@Entity
@Indexed
@NamedQuery(name="HelicopterNameQuery", query="FROM Helicopter WHERE name = :name")
public class Helicopter {
    public static final String BY_NAME = "HelicopterNameQuery";
    private String uuid;
    private String name;
    private String make;

    @Id
    @GeneratedValue(generator="uuid")
    @GenericGenerator(name="uuid", strategy="uuid2")
    public String getUUID() {
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    @Field(analyze=Analyze.NO, store=Store.YES, indexNullAs="#<NULL>#")
    @Column(name="helicopterName")
    @SortableField
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Field(analyze=Analyze.NO, store=Store.YES, indexNullAs="#<NULL>#")
    @SortableField
    public String getMake() {
        return this.make;
    }

    public void setMake(String make) {
        this.make = make;
    }

    public String toString() {
        return "Helicopter [uuid=" + this.uuid + ", name=" + this.name + ", make=" + this.make + "]";
    }
}

