/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.queries;

import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import org.hibernate.ogm.backendtck.queries.Author;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.Store;

@Entity
@Indexed
public class Hypothesis {
    private String id;
    private String description;
    private int position;
    private Date date;
    private Author author;

    @Id
    @SortableField
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Field(analyze=Analyze.NO, store=Store.YES, indexNullAs="#<NULL>#")
    @SortableField
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="pos")
    @Field(analyze=Analyze.NO)
    @NumericField
    @SortableField
    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    @Field(analyze=Analyze.NO)
    @DateBridge(resolution=Resolution.DAY)
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.REMOVE})
    @IndexedEmbedded(indexNullAs="__DEFAULT_NULL_TOKEN__")
    public Author getAuthor() {
        return this.author;
    }

    public void setAuthor(Author author) {
        this.author = author;
    }

    public String toString() {
        return "Hypothesis [id=" + this.id + ", description=" + this.description + ", position=" + this.position + ", date=" + this.date + "]";
    }
}

