/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.queries;

import java.util.List;
import javax.persistence.EntityManager;
import org.fest.assertions.Assertions;
import org.hibernate.ogm.backendtck.queries.Helicopter;
import org.hibernate.ogm.backendtck.queries.Hypothesis;
import org.hibernate.ogm.utils.jpa.OgmJpaTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JpaQueriesTest
extends OgmJpaTestCase {
    private static final String POLICE_HELICOPTER = "Bell 206";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private EntityManager em;

    @Test
    public void testGetResultList() throws Exception {
        List helicopters = this.em.createQuery("FROM Helicopter WHERE name = :name").setParameter("name", (Object)POLICE_HELICOPTER).getResultList();
        Assertions.assertThat((int)helicopters.size()).isEqualTo(1);
        Assertions.assertThat((String)((Helicopter)helicopters.get(0)).getName()).isEqualTo((Object)POLICE_HELICOPTER);
    }

    @Test
    public void testGetResultListWithSelect() throws Exception {
        List helicopters = this.em.createQuery("SELECT h FROM Helicopter h WHERE h.name = :name").setParameter("name", (Object)POLICE_HELICOPTER).getResultList();
        Assertions.assertThat((int)helicopters.size()).isEqualTo(1);
        Assertions.assertThat((String)((Helicopter)helicopters.get(0)).getName()).isEqualTo((Object)POLICE_HELICOPTER);
    }

    @Test
    public void testGetResultListWithTypedQuery() throws Exception {
        List helicopters = this.em.createQuery("FROM Helicopter WHERE name = :name", Helicopter.class).setParameter("name", (Object)POLICE_HELICOPTER).getResultList();
        Assertions.assertThat((int)helicopters.size()).isEqualTo(1);
        Assertions.assertThat((String)((Helicopter)helicopters.get(0)).getName()).isEqualTo((Object)POLICE_HELICOPTER);
    }

    @Test
    public void testGetResultListSize() throws Exception {
        List helicopters = this.em.createQuery("FROM Helicopter").getResultList();
        Assertions.assertThat((int)helicopters.size()).isEqualTo(2);
    }

    @Test
    public void testGetResultListSizeWithTypedQuery() throws Exception {
        List helicopters = this.em.createQuery("FROM Helicopter", Helicopter.class).getResultList();
        Assertions.assertThat((int)helicopters.size()).isEqualTo(2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetResultListSizeWithWrongReturnedClass() throws Exception {
        this.em.createQuery("FROM Helicopter", Hypothesis.class);
    }

    @Test
    public void testSingleResult() throws Exception {
        Helicopter helicopter = (Helicopter)this.em.createQuery("FROM Helicopter WHERE name = :name").setParameter("name", (Object)POLICE_HELICOPTER).getSingleResult();
        Assertions.assertThat((String)helicopter.getName()).isEqualTo((Object)POLICE_HELICOPTER);
    }

    @Test
    public void testGetSingleResultTypedQuery() throws Exception {
        Helicopter helicopter = (Helicopter)this.em.createQuery("FROM Helicopter WHERE name = :name", Helicopter.class).setParameter("name", (Object)POLICE_HELICOPTER).getSingleResult();
        Assertions.assertThat((String)helicopter.getName()).isEqualTo((Object)POLICE_HELICOPTER);
    }

    @Test
    public void testCreateNamedQuery() throws Exception {
        Helicopter helicopter = (Helicopter)this.em.createNamedQuery("HelicopterNameQuery").setParameter("name", (Object)POLICE_HELICOPTER).getSingleResult();
        Assertions.assertThat((String)helicopter.getName()).isEqualTo((Object)POLICE_HELICOPTER);
    }

    @Test
    public void testCreateNamedQueryTypeQuery() throws Exception {
        Helicopter helicopter = (Helicopter)this.em.createNamedQuery("HelicopterNameQuery", Helicopter.class).setParameter("name", (Object)POLICE_HELICOPTER).getSingleResult();
        Assertions.assertThat((String)helicopter.getName()).isEqualTo((Object)POLICE_HELICOPTER);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateNamedQueryTypeQueryWithWrongReturnedClass() throws Exception {
        this.em.createNamedQuery("HelicopterNameQuery", Hypothesis.class).setParameter("name", (Object)POLICE_HELICOPTER).getSingleResult();
    }

    @Test
    public void testAddedNamedQuery() throws Exception {
        String allHelicopters = "AllHelicopters";
        this.getFactory().addNamedQuery("AllHelicopters", this.em.createQuery("FROM Helicopter"));
        List helicopters = this.em.createNamedQuery("AllHelicopters").getResultList();
        Assertions.assertThat((int)helicopters.size()).isEqualTo(2);
    }

    @Before
    public void populateDb() throws Exception {
        this.em = this.getFactory().createEntityManager();
        this.em.getTransaction().begin();
        this.em.persist((Object)this.helicopter(POLICE_HELICOPTER));
        this.em.persist((Object)this.helicopter("AW139SAR"));
        this.em.getTransaction().commit();
        this.em.clear();
        this.em.getTransaction().begin();
    }

    @After
    public void closeEmAndRemoveEntities() throws Exception {
        if (this.em != null) {
            this.em.getTransaction().commit();
            this.em.close();
            this.removeEntities();
        }
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Helicopter.class};
    }

    private Helicopter helicopter(String name) {
        Helicopter helicopter = new Helicopter();
        helicopter.setName(name);
        return helicopter;
    }
}

