/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.queries;

import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import javax.persistence.EntityManager;
import org.fest.assertions.Assertions;
import org.hibernate.ogm.backendtck.queries.Address;
import org.hibernate.ogm.backendtck.queries.Author;
import org.hibernate.ogm.backendtck.queries.Hypothesis;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.hibernate.ogm.utils.jpa.OgmJpaTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@SkipByGridDialect(value={GridDialectType.CASSANDRA, GridDialectType.COUCHDB, GridDialectType.EHCACHE, GridDialectType.HASHMAP, GridDialectType.INFINISPAN, GridDialectType.REDIS_JSON, GridDialectType.REDIS_HASH, GridDialectType.INFINISPAN_REMOTE}, comment="We need a QueryParserService to be able to perform these queries.")
public class QueriesWithAssociationsTest
extends OgmJpaTestCase {
    private EntityManager em;

    @Test
    public void testGetWithObjectComparison() throws Exception {
        Author alma = (Author)this.em.createQuery("FROM Author WHERE name = :name").setParameter("name", (Object)"alma").getSingleResult();
        Author alfred = (Author)this.em.createQuery("FROM Author WHERE name = :name").setParameter("name", (Object)"alfred").getSingleResult();
        Author alphonse = (Author)this.em.createQuery("FROM Author WHERE name = :name").setParameter("name", (Object)"alphonse").getSingleResult();
        List hypothesis = this.em.createQuery("FROM Hypothesis WHERE author = :author").setParameter("author", (Object)alma).getResultList();
        Assertions.assertThat((int)hypothesis.size()).isEqualTo(1);
        Assertions.assertThat((Object)((Hypothesis)hypothesis.get(0)).getAuthor()).isEqualTo((Object)alma);
        hypothesis = this.em.createQuery("FROM Hypothesis WHERE author = :author").setParameter("author", (Object)alfred).getResultList();
        Assertions.assertThat((int)hypothesis.size()).isEqualTo(1);
        Assertions.assertThat((Object)((Hypothesis)hypothesis.get(0)).getAuthor()).isEqualTo((Object)alfred);
        hypothesis = this.em.createQuery("FROM Hypothesis WHERE author = :author").setParameter("author", (Object)alphonse).getResultList();
        Assertions.assertThat((int)hypothesis.size()).isEqualTo(0);
        hypothesis = this.em.createQuery("FROM Hypothesis WHERE author IN(:authors)").setParameter("authors", Arrays.asList(alma, alfred)).getResultList();
        Assertions.assertThat((int)hypothesis.size()).isEqualTo(2);
        Assertions.assertThat((List)hypothesis).onProperty("author").containsOnly(new Object[]{alma, alfred});
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.CASSANDRA, GridDialectType.COUCHDB, GridDialectType.EHCACHE, GridDialectType.HASHMAP, GridDialectType.INFINISPAN, GridDialectType.REDIS_JSON, GridDialectType.REDIS_HASH, GridDialectType.MONGODB}, comment="We need to be able to join on associations. Currently, only the Neo4j dialect supports it.")
    public void testGetWithJoinOnAssociations() throws Exception {
        Author alma = (Author)this.em.createQuery("FROM Author WHERE name = :name").setParameter("name", (Object)"alma").getSingleResult();
        Author alfred = (Author)this.em.createQuery("FROM Author WHERE name = :name").setParameter("name", (Object)"alfred").getSingleResult();
        Address garibaldiStreet = (Address)this.em.find(Address.class, (Object)2L);
        List hypothesis = this.em.createQuery("FROM Hypothesis WHERE author.name = :authorName").setParameter("authorName", (Object)alma.getName()).getResultList();
        Assertions.assertThat((int)hypothesis.size()).isEqualTo(1);
        Assertions.assertThat((List)hypothesis).onProperty("author").containsOnly(new Object[]{alma});
        hypothesis = this.em.createQuery("FROM Hypothesis WHERE author.address = :address").setParameter("address", (Object)garibaldiStreet).getResultList();
        Assertions.assertThat((int)hypothesis.size()).isEqualTo(1);
        Assertions.assertThat((List)hypothesis).onProperty("author").containsOnly(new Object[]{alma});
        hypothesis = this.em.createQuery("FROM Hypothesis WHERE author.address.city = :city ORDER BY author.address.city").setParameter("city", (Object)"London").getResultList();
        Assertions.assertThat((int)hypothesis.size()).isEqualTo(1);
        Assertions.assertThat((List)hypothesis).onProperty("author").containsOnly(new Object[]{alfred});
        hypothesis = this.em.createQuery("FROM Hypothesis ORDER BY author.name DESC, id ASC").getResultList();
        Assertions.assertThat((List)hypothesis).onProperty("id").containsExactly(new Object[]{"13", "15", "14", "16"});
    }

    @Before
    public void populateDb() throws Exception {
        this.em = this.getFactory().createEntityManager();
        this.em.getTransaction().begin();
        Address mainStreet = new Address();
        mainStreet.setId(1L);
        mainStreet.setCity("London");
        mainStreet.setStreet("Main Street");
        this.em.persist((Object)mainStreet);
        Address garibaldiStreet = new Address();
        garibaldiStreet.setId(2L);
        garibaldiStreet.setCity("Lyon");
        garibaldiStreet.setStreet("rue Garibaldi");
        this.em.persist((Object)garibaldiStreet);
        Address monumentStreet = new Address();
        monumentStreet.setId(3L);
        monumentStreet.setCity("London");
        monumentStreet.setStreet("Monument Street");
        this.em.persist((Object)monumentStreet);
        Author alfred = new Author();
        alfred.setId(1L);
        alfred.setName("alfred");
        alfred.setAddress(mainStreet);
        this.em.persist((Object)alfred);
        Author alma = new Author();
        alma.setId(2L);
        alma.setName("alma");
        alma.setAddress(garibaldiStreet);
        this.em.persist((Object)alma);
        Author alphonse = new Author();
        alphonse.setId(3L);
        alphonse.setName("alphonse");
        alphonse.setAddress(monumentStreet);
        this.em.persist((Object)alphonse);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.clear();
        calendar.set(2012, 8, 25);
        Hypothesis socrates = new Hypothesis();
        socrates.setId("13");
        socrates.setDescription("There are more than two dimensions over the shadows we see out of the cave");
        socrates.setPosition(1);
        socrates.setDate(calendar.getTime());
        this.em.persist((Object)socrates);
        calendar.set(1, 2011);
        Hypothesis peano = new Hypothesis();
        peano.setId("14");
        peano.setDescription("Peano's curve and then Hilbert's space filling curve proof the connection from mono-dimensional to bi-dimensional space");
        peano.setPosition(2);
        peano.setDate(calendar.getTime());
        peano.setAuthor(alma);
        this.em.persist((Object)peano);
        calendar.set(1, 2010);
        Hypothesis sanne = new Hypothesis();
        sanne.setId("15");
        sanne.setDescription("Hilbert's proof of connection to 2 dimensions can be induced to reason on N dimensions");
        sanne.setPosition(3);
        sanne.setDate(calendar.getTime());
        this.em.persist((Object)sanne);
        calendar.set(1, 2009);
        Hypothesis shortOne = new Hypothesis();
        shortOne.setId("16");
        shortOne.setDescription("stuff works");
        shortOne.setPosition(4);
        shortOne.setDate(calendar.getTime());
        shortOne.setAuthor(alfred);
        this.em.persist((Object)shortOne);
        this.em.getTransaction().commit();
        this.em.clear();
        this.em.getTransaction().begin();
    }

    @After
    public void closeEmAndRemoveEntities() throws Exception {
        if (this.em != null) {
            this.em.getTransaction().commit();
            this.em.close();
            this.removeEntities();
        }
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Hypothesis.class, Author.class, Address.class};
    }
}

