/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.queries;

import java.util.Arrays;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.ogm.backendtck.queries.Ending;
import org.hibernate.ogm.backendtck.queries.OptionalStoryBranch;
import org.hibernate.ogm.backendtck.queries.StoryBranch;
import org.hibernate.ogm.backendtck.queries.StoryGame;
import org.hibernate.ogm.datastore.impl.DatastoreProviderType;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.OgmAssertions;
import org.hibernate.ogm.utils.OgmTestCase;
import org.hibernate.ogm.utils.SessionHelper;
import org.hibernate.ogm.utils.SkipByDatastoreProvider;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.hibernate.ogm.utils.TestSessionFactory;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@SkipByGridDialect(value={GridDialectType.CASSANDRA, GridDialectType.INFINISPAN_REMOTE}, comment="Bag semantics not supported by backends which require a primary key")
public class QueriesWithEmbeddedCollectionTest
extends OgmTestCase {
    @TestSessionFactory
    public static SessionFactory sessions;
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private Session session;
    private Transaction tx;

    @Before
    public void createSession() {
        this.closeSession();
        this.session = sessions.openSession();
        this.tx = this.session.beginTransaction();
    }

    @After
    public void closeSession() {
        if (this.tx != null && this.tx.getStatus() == TransactionStatus.ACTIVE) {
            this.tx.commit();
            this.tx = null;
        }
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.CASSANDRA, GridDialectType.COUCHDB, GridDialectType.EHCACHE, GridDialectType.HASHMAP, GridDialectType.INFINISPAN, GridDialectType.INFINISPAN_REMOTE, GridDialectType.REDIS_JSON, GridDialectType.REDIS_HASH}, comment="The parser does not support this at the moment")
    public void testEqualOperatorWithCollectionOfElements() throws Exception {
        List result = this.session.createQuery("FROM StoryGame story JOIN story.dwarves d WHERE d = 'Dwalin' ").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{300L});
    }

    @Test
    public void testEqualOperatorWithEmbeddedCollection() throws Exception {
        List result = this.session.createQuery("FROM StoryGame story JOIN story.chaoticBranches c WHERE c.evilText = '[ARTIFACT] Search for the evil artifact'").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{1L});
    }

    @Test
    public void testInOperatorWithEmbeddedCollection() throws Exception {
        List result = this.session.createQuery("from StoryGame story JOIN story.chaoticBranches c WHERE c.evilText IN ( '[ARTIFACT] Search for the evil artifact' )").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{1L});
    }

    @Test
    public void testBetweenOperatorWithEmbeddedCollection() throws Exception {
        List result = this.session.createQuery("FROM StoryGame story JOIN story.chaoticBranches c WHERE c.evilText BETWEEN '[' AND '[B'").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{1L});
    }

    @Test
    public void testLikeOperatorWithEmbeddedCollection() throws Exception {
        List result = this.session.createQuery("FROM StoryGame story JOIN story.chaoticBranches c WHERE c.evilText LIKE '[ART%'").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{1L});
    }

    @Test
    public void testEqualEmbeddedCollectionWithEmbeddableInCollectionWhereClause() throws Exception {
        List result = this.session.createQuery("FROM StoryGame story JOIN story.chaoticBranches c WHERE c.evilText = '[VENDETTA] assassinate the leader of the party'").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{1L});
    }

    @Test
    public void testConjunctionOperatorWithEmbeddedInEmbeddedCollection() throws Exception {
        List result = this.session.createQuery("FROM StoryGame story JOIN story.chaoticBranches c WHERE c.evilText = '[ARTIFACT] Search for the evil artifact' AND c.goodText IN ('[BANDITS] you punish the bandits')").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{1L});
    }

    @Test
    public void testBetweenOperatorWithEmbeddedInEmbeddedCollection() throws Exception {
        List result = this.session.createQuery("FROM StoryGame story JOIN story.chaoticBranches c WHERE c.evilEnding.score BETWEEN -100 AND 100").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{1L});
    }

    @Test
    public void testLikeOperatorWithEmbeddedInEmbeddedCollection() throws Exception {
        List result = this.session.createQuery("FROM StoryGame story JOIN story.chaoticBranches c WHERE c.evilEnding.text LIKE '[VENDETT%'").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{1L});
    }

    @Test
    public void testEqualOperatorWithEmbeddedInEmbeddedCollectionForString() throws Exception {
        List result = this.session.createQuery("FROM StoryGame story JOIN story.chaoticBranches c WHERE c.evilEnding.text = '[VENDETTA] you become a demon'").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{1L});
    }

    @Test
    public void testEqualOperatorWithEmbeddedInEmbeddedCollectionForInteger() throws Exception {
        List result = this.session.createQuery("FROM StoryGame story JOIN story.chaoticBranches c WHERE c.evilEnding.score = 10").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{1L});
    }

    @Test
    public void testConjunctionOperatorEqualOperatorWithEmbeddedInEmbeddedCollection() throws Exception {
        List result = this.session.createQuery("FROM StoryGame story JOIN story.chaoticBranches c WHERE c.evilText = '[VENDETTA] assassinate the leader of the party' AND c.evilEnding.text IN ('[VENDETTA] you become a demon')").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{1L});
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.CASSANDRA, GridDialectType.COUCHDB, GridDialectType.EHCACHE, GridDialectType.HASHMAP, GridDialectType.INFINISPAN, GridDialectType.INFINISPAN_REMOTE, GridDialectType.INFINISPAN_REMOTE, GridDialectType.REDIS_JSON, GridDialectType.REDIS_HASH}, comment="Hibernate Search cannot project multiple values from the same field at the moment")
    @SkipByDatastoreProvider(value={DatastoreProviderType.FONGO}, comment="OGM-835 - needs a Fongo upgrade (once available)")
    public void testProjectionsOfPropertyInEmbeddedCollection() throws Exception {
        List result = this.session.createQuery("SELECT c.evilText FROM StoryGame story JOIN story.chaoticBranches c WHERE story.id = 1").list();
        OgmAssertions.assertThat(result).containsOnly(new Object[]{"[ARTIFACT] Search for the evil artifact", "[VENDETTA] assassinate the leader of the party"});
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.CASSANDRA, GridDialectType.COUCHDB, GridDialectType.EHCACHE, GridDialectType.HASHMAP, GridDialectType.INFINISPAN, GridDialectType.INFINISPAN_REMOTE, GridDialectType.REDIS_JSON, GridDialectType.REDIS_HASH}, comment="Hibernate Search cannot project multiple values from the same field at the moment")
    @SkipByDatastoreProvider(value={DatastoreProviderType.FONGO}, comment="OGM-835 - needs a Fongo upgrade (once available)")
    public void testProjectionsOfEmbeddedInEmbeddedCollection() throws Exception {
        List result = this.session.createQuery("SELECT c.evilEnding.score FROM StoryGame story JOIN story.chaoticBranches c WHERE story.id = 1").list();
        OgmAssertions.assertThat(result).containsOnly(new Object[]{5, 10});
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.CASSANDRA, GridDialectType.COUCHDB, GridDialectType.EHCACHE, GridDialectType.HASHMAP, GridDialectType.INFINISPAN, GridDialectType.INFINISPAN_REMOTE, GridDialectType.REDIS_JSON, GridDialectType.REDIS_HASH}, comment="Hibernate Search cannot project multiple values from the same field at the moment")
    @SkipByDatastoreProvider(value={DatastoreProviderType.FONGO}, comment="OGM-835 - needs a Fongo upgrade (once available)")
    public void testProjectionsOfEmbeddedInEmbeddedCollectionWithNull() throws Exception {
        List result = this.session.createQuery("SELECT c.evilEnding.score FROM StoryGame story JOIN story.chaoticBranches c WHERE story.id = 20").list();
        OgmAssertions.assertThat(result).containsOnly(new Object[]{null, 333});
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.CASSANDRA, GridDialectType.COUCHDB, GridDialectType.EHCACHE, GridDialectType.HASHMAP, GridDialectType.INFINISPAN, GridDialectType.INFINISPAN_REMOTE, GridDialectType.REDIS_JSON, GridDialectType.REDIS_HASH}, comment="Hibernate Search cannot project multiple values from the same field at the moment")
    @SkipByDatastoreProvider(value={DatastoreProviderType.FONGO}, comment="OGM-835 - needs a Fongo upgrade (once available)")
    public void testProjectionsOfPropertiesInEmbeddedCollection() throws Exception {
        List<SessionHelper.ProjectionResult> result = SessionHelper.asProjectionResults(this.session, "SELECT story.id, story.goodBranch.storyText, c.evilEnding.text, c.evilText FROM StoryGame story JOIN story.chaoticBranches c WHERE story.id = 1");
        OgmAssertions.assertThat(result).containsOnly(new Object[]{new SessionHelper.ProjectionResult(1L, "[VILLAGE] You go to the village", "[ARTIFACT] You succumb to the dark side", "[ARTIFACT] Search for the evil artifact"), new SessionHelper.ProjectionResult(1L, "[VILLAGE] You go to the village", "[VENDETTA] you become a demon", "[VENDETTA] assassinate the leader of the party")});
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.CASSANDRA, GridDialectType.COUCHDB, GridDialectType.EHCACHE, GridDialectType.HASHMAP, GridDialectType.INFINISPAN, GridDialectType.INFINISPAN_REMOTE, GridDialectType.REDIS_JSON, GridDialectType.REDIS_HASH}, comment="Hibernate Search cannot project multiple values from the same field at the moment")
    @SkipByDatastoreProvider(value={DatastoreProviderType.FONGO}, comment="OGM-835 - needs a Fongo upgrade (once available)")
    public void testProjectionsOfPropertiesInEmbeddedCollectionWithInnerJoin() throws Exception {
        List<SessionHelper.ProjectionResult> result = SessionHelper.asProjectionResults(this.session, "SELECT story.id, story.goodBranch.storyText, c.evilEnding.text, c.evilText FROM StoryGame story JOIN story.chaoticBranches c ");
        OgmAssertions.assertThat(result).containsOnly(new Object[]{new SessionHelper.ProjectionResult(1L, "[VILLAGE] You go to the village", "[ARTIFACT] You succumb to the dark side", "[ARTIFACT] Search for the evil artifact"), new SessionHelper.ProjectionResult(1L, "[VILLAGE] You go to the village", "[VENDETTA] you become a demon", "[VENDETTA] assassinate the leader of the party"), new SessionHelper.ProjectionResult(20L, "[CAVE] You go the cave", null, "[KING] Ask for your help"), new SessionHelper.ProjectionResult(20L, "[CAVE] You go the cave", "[WEREWOLF] Sometimes people hear you howl at the moon", "[WEREWOLF] You become a werewolf")});
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.CASSANDRA, GridDialectType.COUCHDB, GridDialectType.EHCACHE, GridDialectType.HASHMAP, GridDialectType.INFINISPAN, GridDialectType.INFINISPAN_REMOTE, GridDialectType.REDIS_JSON, GridDialectType.REDIS_HASH}, comment="Hibernate Search cannot project multiple values from the same field at the moment")
    @SkipByDatastoreProvider(value={DatastoreProviderType.FONGO}, comment="OGM-835 - needs a Fongo upgrade (once available)")
    public void testProjectionWithMultipleAssociations() throws Exception {
        List<SessionHelper.ProjectionResult> result = SessionHelper.asProjectionResults(this.session, "SELECT story.id, c.evilEnding.text, n.evilText FROM StoryGame story JOIN story.chaoticBranches c JOIN story.neutralBranches n WHERE story.id = 1");
        OgmAssertions.assertThat(result).containsOnly(new Object[]{new SessionHelper.ProjectionResult(1L, "[ARTIFACT] You succumb to the dark side", "[VENDETTA] Kill the king"), new SessionHelper.ProjectionResult(1L, "[ARTIFACT] You succumb to the dark side", "[THIEF] steal the artifact"), new SessionHelper.ProjectionResult(1L, "[VENDETTA] you become a demon", "[VENDETTA] Kill the king"), new SessionHelper.ProjectionResult(1L, "[VENDETTA] you become a demon", "[THIEF] steal the artifact")});
    }

    @Test
    public void testQueryReturningEmbeddedObject() {
        List list = this.session.createQuery("FROM StoryGame story WHERE story.id = 1").list();
        OgmAssertions.assertThat(list).onProperty("goodBranch").onProperty("storyText").containsExactly("[VILLAGE] You go to the village");
        OgmAssertions.assertThat(list).onProperty("goodBranch").onProperty("ending").onProperty("text").containsExactly("[VILLAGE] Everybody is happy");
        List<Ending> additionalEndings = ((StoryGame)list.get(0)).getGoodBranch().getAdditionalEndings();
        OgmAssertions.assertThat(additionalEndings).onProperty("text").containsOnly(new Object[]{"[DRAGON] Slay the dragon"});
        OgmAssertions.assertThat(additionalEndings).onProperty("score").containsOnly(new Object[]{5});
        OgmAssertions.assertThat(list).onProperty("evilBranch").onProperty("storyText").containsExactly("[EVIL] you kill the villagers");
        List<OptionalStoryBranch> chaoticBranches = ((StoryGame)list.get(0)).getChaoticBranches();
        OgmAssertions.assertThat(chaoticBranches).onProperty("evilText").containsOnly(new Object[]{"[ARTIFACT] Search for the evil artifact", "[VENDETTA] assassinate the leader of the party"});
        OgmAssertions.assertThat(chaoticBranches).onProperty("evilEnding").containsOnly(new Object[]{new Ending("[ARTIFACT] You succumb to the dark side", 5), new Ending("[VENDETTA] you become a demon", 10)});
        OgmAssertions.assertThat(chaoticBranches).onProperty("goodText").containsOnly(new Object[]{"[BANDITS] you punish the bandits", null});
        List<OptionalStoryBranch> neutralBranches = ((StoryGame)list.get(0)).getNeutralBranches();
        OgmAssertions.assertThat(neutralBranches).onProperty("evilText").containsOnly(new Object[]{"[THIEF] steal the artifact", "[VENDETTA] Kill the king"});
        OgmAssertions.assertThat(neutralBranches).onProperty("goodText").containsOnly(new Object[]{null, null});
    }

    @BeforeClass
    public static void insertTestEntities() throws Exception {
        StoryGame story1 = new StoryGame(1L, null);
        StoryBranch story1GoodBranch = new StoryBranch("[VILLAGE] You go to the village", new Ending("[VILLAGE] Everybody is happy", 1));
        story1GoodBranch.setAdditionalEndings(Arrays.asList(new Ending("[DRAGON] Slay the dragon", 5)));
        story1.setGoodBranch(story1GoodBranch);
        story1.setEvilBranch(new StoryBranch("[EVIL] you kill the villagers"));
        story1.setChaoticBranches(Arrays.asList(new OptionalStoryBranch("[ARTIFACT] Search for the evil artifact", "[BANDITS] you punish the bandits", new Ending("[ARTIFACT] You succumb to the dark side", 5)), new OptionalStoryBranch("[VENDETTA] assassinate the leader of the party", null, new Ending("[VENDETTA] you become a demon", 10))));
        story1.setNeutralBranches(Arrays.asList(new OptionalStoryBranch("[THIEF] steal the artifact", null, null), new OptionalStoryBranch("[VENDETTA] Kill the king", null, null)));
        StoryGame story2 = new StoryGame(20L, new StoryBranch("[CAVE] You go the cave", new Ending("[CAVE] It's dark", 20)));
        story2.setEvilBranch(new StoryBranch("[VAMPIRE] You are now a vampire", null));
        story2.setChaoticBranches(Arrays.asList(new OptionalStoryBranch("[KING] Ask for your help", "[BLACKSMITH] The blacksmith send you for a quest", null), new OptionalStoryBranch("[WEREWOLF] You become a werewolf", null, new Ending("[WEREWOLF] Sometimes people hear you howl at the moon", 333))));
        StoryGame story3 = new StoryGame(300L, new StoryBranch("[DUNGEON] You go to the dungeon", null));
        story3.setEvilBranch(new StoryBranch("[DUNGEON] You become the dungeon keeper", null));
        story3.setDwarves(Arrays.asList("Dwalin", "Balin", "Kili", "Fili", "Dori", "Nori", "Ori", "Oin", "Gloin", "Bifur", "Bofur", "Bombur", "Thorin"));
        SessionHelper.persist(sessions, story1, story2, story3);
    }

    @AfterClass
    public static void removeTestEntities() throws Exception {
        SessionHelper.delete(sessions, StoryGame.class, Long.valueOf(1L), Long.valueOf(20L), Long.valueOf(300L));
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{StoryGame.class};
    }
}

