/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.queries;

import javax.persistence.EntityManager;
import org.fest.assertions.Assertions;
import org.hibernate.ogm.backendtck.queries.Address;
import org.hibernate.ogm.backendtck.queries.Author;
import org.hibernate.ogm.backendtck.queries.Hypothesis;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.hibernate.ogm.utils.jpa.OgmJpaTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@SkipByGridDialect(value={GridDialectType.CASSANDRA, GridDialectType.COUCHDB, GridDialectType.EHCACHE, GridDialectType.HASHMAP, GridDialectType.INFINISPAN, GridDialectType.INFINISPAN_REMOTE, GridDialectType.REDIS_JSON, GridDialectType.REDIS_HASH}, comment="We need a QueryParserService to be able to perform these queries.")
public class QueriesWithToOnePropertyTest
extends OgmJpaTestCase {
    private EntityManager em;

    @Test
    public void testJPQL() throws Exception {
        Author alma = (Author)this.em.createQuery("FROM Author WHERE name = :name").setParameter("name", (Object)"alma").getSingleResult();
        Assertions.assertThat((Object)alma.getAddress()).isNotNull();
    }

    @Before
    public void populateDb() throws Exception {
        this.em = this.getFactory().createEntityManager();
        this.em.getTransaction().begin();
        Address mainStreet = new Address();
        mainStreet.setId(1L);
        mainStreet.setCity("London");
        mainStreet.setStreet("Main Street");
        this.em.persist((Object)mainStreet);
        Author alma = new Author();
        alma.setId(2L);
        alma.setName("alma");
        alma.setAddress(mainStreet);
        this.em.persist((Object)alma);
        this.em.getTransaction().commit();
        this.em.clear();
        this.em.getTransaction().begin();
    }

    @After
    public void closeEmAndRemoveEntities() throws Exception {
        if (this.em != null) {
            this.em.getTransaction().commit();
            this.em.close();
            this.removeEntities();
        }
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Author.class, Address.class, Hypothesis.class};
    }
}

