/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.queries;

import org.fest.assertions.Assertions;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.queries.Helicopter;
import org.hibernate.ogm.utils.OgmTestCase;
import org.junit.Before;
import org.junit.Test;

public class QueryUpdateTest
extends OgmTestCase {
    @Before
    public void insertTestEntities() throws Exception {
        OgmSession session = this.sessionFactory.openSession();
        Transaction transaction = session.beginTransaction();
        Helicopter helicopter = new Helicopter();
        helicopter.setMake("Lama");
        helicopter.setName("Sergio");
        session.persist((Object)helicopter);
        transaction.commit();
        session.close();
    }

    @Test
    public void canUpdateEntityReturnedByQuery() {
        OgmSession session = this.sessionFactory.openSession();
        Transaction transaction = session.beginTransaction();
        Query query = session.createQuery("from Helicopter h where name = 'Sergio'");
        Helicopter helicopter = (Helicopter)query.uniqueResult();
        Assertions.assertThat((Object)helicopter).isNotNull();
        helicopter.setName("Leonie");
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        query = session.createQuery("from Helicopter h where name = 'Leonie'");
        helicopter = (Helicopter)query.uniqueResult();
        Assertions.assertThat((Object)helicopter).isNotNull();
        transaction.commit();
        session.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Helicopter.class};
    }
}

