/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.queries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.TimeZone;
import org.fest.assertions.ListAssert;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.hql.ParsingException;
import org.hibernate.ogm.backendtck.queries.Address;
import org.hibernate.ogm.backendtck.queries.Author;
import org.hibernate.ogm.backendtck.queries.Helicopter;
import org.hibernate.ogm.backendtck.queries.Hypothesis;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.OgmAssertions;
import org.hibernate.ogm.utils.OgmTestCase;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.hibernate.ogm.utils.TestHelper;
import org.hibernate.ogm.utils.TestSessionFactory;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SimpleQueriesTest
extends OgmTestCase {
    @TestSessionFactory
    public static SessionFactory sessions;
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private Session session;
    private Transaction tx;

    @Before
    public void createSession() {
        this.closeSession();
        this.session = sessions.openSession();
        this.tx = this.session.beginTransaction();
    }

    @After
    public void closeSession() {
        if (this.tx != null && this.tx.getStatus() == TransactionStatus.ACTIVE) {
            this.tx.commit();
            this.tx = null;
        }
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    @Test
    public void testSimpleQueries() throws Exception {
        this.assertQuery(this.session, 8, this.session.createQuery("from Hypothesis"));
        this.assertQuery(this.session, 8, this.session.createQuery("from org.hibernate.ogm.backendtck.queries.Hypothesis"));
        this.assertQuery(this.session, 5, this.session.createQuery("from Helicopter"));
    }

    @Test
    public void testSimpleQueryOnUnindexedSuperType() throws Exception {
        this.assertQuery(this.session, 17, this.session.createQuery("from java.lang.Object"));
    }

    @Test
    public void testFailingQuery() {
        this.thrown.expect(HibernateException.class);
        this.thrown.expectMessage("OGM000024");
        this.assertQuery(this.session, 4, this.session.createQuery("from Object"));
    }

    @Test
    public void testConstantParameterQueries() throws Exception {
        this.assertQuery(this.session, 1, this.session.createQuery("from Hypothesis h where h.description = 'stuff works'"));
    }

    @Test
    public void testUnqualifiedProjectionQuery() throws Exception {
        List<ProjectionResult> projectionResult = this.asProjectionResults("select id, description from Hypothesis h where id = 16");
        OgmAssertions.assertThat(projectionResult).containsOnly(new Object[]{new ProjectionResult("16", "stuff works")});
    }

    @Test
    public void testQualifiedProjectionQuery() throws Exception {
        List<ProjectionResult> projectionResult = this.asProjectionResults("select h.id, h.description from Hypothesis h where h.id = 16");
        OgmAssertions.assertThat(projectionResult).containsOnly(new Object[]{new ProjectionResult("16", "stuff works")});
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.MONGODB, GridDialectType.NEO4J_EMBEDDED, GridDialectType.NEO4J_REMOTE}, comment="Selecting from associations is not yet implemented.")
    public void testSelectingAttributeFromAssociatedEntityInProjectionQuery() throws Exception {
        List<ProjectionResult> projectionResult = this.asProjectionResults("select h.author.name from Hypothesis h where h.id = 16");
        OgmAssertions.assertThat(projectionResult).containsOnly(new Object[]{new ProjectionResult("alfred")});
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.MONGODB, GridDialectType.NEO4J_EMBEDDED, GridDialectType.NEO4J_REMOTE}, comment="Selecting from associations is not yet implemented.")
    public void testSelectingAttributeFromIndirectlyAssociatedEntityInProjectionQuery() throws Exception {
        List<ProjectionResult> projectionResult = this.asProjectionResults("select h.author.address.street from Hypothesis h where h.id = 16");
        OgmAssertions.assertThat(projectionResult).containsOnly(new Object[]{new ProjectionResult("Main Street")});
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.MONGODB, GridDialectType.NEO4J_EMBEDDED, GridDialectType.NEO4J_REMOTE}, comment="Projecting complete entity is not yet implemented.")
    public void testSelectingCompleteEntityInProjectionQuery() throws Exception {
        List projectionResult = this.session.createQuery("select h, h.id from Hypothesis h where h.id = 16").list();
        OgmAssertions.assertThat(projectionResult).hasSize(1);
        Object[] singleResult = (Object[])projectionResult.get(0);
        OgmAssertions.assertThat((String)((Hypothesis)singleResult[0]).getId()).isEqualTo((Object)"16");
        OgmAssertions.assertThat((Object)singleResult[1]).isEqualTo((Object)"16");
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.MONGODB, GridDialectType.NEO4J_EMBEDDED, GridDialectType.NEO4J_REMOTE}, comment="Doesn't apply to MongoDB or Neo4j queries.")
    public void testSelectingCompleteIndexedEmbeddedEntityInProjectionQueryRaisesException() throws Exception {
        this.thrown.expect(ParsingException.class);
        this.thrown.expectMessage("HQL100005");
        this.session.createQuery("select h.author from Hypothesis h").list();
    }

    @Test
    public void testRestrictingOnPropertyWithConfiguredColumnName() throws Exception {
        List results = this.session.createQuery("from Hypothesis h where h.position = '2'").list();
        OgmAssertions.assertThat(results).onProperty("id").containsOnly(new Object[]{"14"});
    }

    @Test
    public void testNegatedQuery() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where not h.id = '13'").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"14", "15", "16", "17", "18", "19", "20"});
    }

    @Test
    public void testNegatedQueryOnNumericProperty() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.position <> 4").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"13", "14", "15", "17", "18", "19"});
    }

    @Test
    public void testQueryWithConjunctionAndNegation() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.position = 2 and not h.id = '13'").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"14"});
    }

    @Test
    public void testQueryWithRangeAndNegation() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.position between 2 and 3 and not h.id = '13'").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"14", "15"});
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.MONGODB, GridDialectType.NEO4J_EMBEDDED, GridDialectType.NEO4J_REMOTE}, comment="Selecting from associations is not yet implemented.")
    public void testQueryWithPropertyFromAssociatedEntityInWhereClause() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.author.name = 'alfred'").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"16"});
    }

    @Test
    public void testConstantNumericQuery() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.id = 13").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"13"});
    }

    @Test
    public void testParametricQueries() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.description = :myParam").setString("myParam", "stuff works").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"16"});
    }

    @Test
    public void testConstantParameterRangeQuery() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.description BETWEEN 'H' and 'Q'").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"14", "15", "17"});
    }

    @Test
    public void testRangeQueryWithParameters() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.description BETWEEN :start and :end").setString("start", "Hilbers").setString("end", "Peanq").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"14", "15", "17"});
    }

    @Test
    public void testDateRangeQueryWithParameters() throws Exception {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.clear();
        calendar.set(2009, 0, 1);
        Date start = calendar.getTime();
        calendar.set(2010, 11, 31);
        Date end = calendar.getTime();
        List result = this.session.createQuery("from Hypothesis h where h.date BETWEEN :start and :end").setDate("start", start).setDate("end", end).list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"15", "16"});
    }

    @Test
    public void testConstantParameterNumericRangeQuery() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.position BETWEEN 1 and 2").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"13", "14"});
    }

    @Test
    public void testLessQuery() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.position < 3").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"13", "14"});
    }

    @Test
    public void testNotLessQuery() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where NOT h.position < 3").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"15", "16", "17", "18", "19", "20"});
    }

    @Test
    public void testLessOrEqualsQuery() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.position <= 3").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"13", "14", "15"});
    }

    @Test
    public void testNotLessOrEqualsQuery() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where NOT h.position <= 3").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"16", "17", "18", "19", "20"});
    }

    @Test
    public void testGreaterOrEqualsQuery() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.position >= 2").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"14", "15", "16", "17", "18", "19", "20"});
    }

    @Test
    public void testGreaterQuery() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.position > 2").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"15", "16", "17", "18", "19", "20"});
    }

    @Test
    public void testInQuery() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.position IN (2, 3, 4)").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"14", "15", "16", "20"});
    }

    @Test
    public void testInQueryOnStringProperty() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.id IN ('15', '16')").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"15", "16"});
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.MONGODB, GridDialectType.NEO4J_EMBEDDED, GridDialectType.NEO4J_REMOTE}, comment="Selecting from associated entities is not yet implemented.")
    public void testInQueryOnAssociatedEntity() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.author.name IN ('alma', 'alfred')").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"14", "16"});
    }

    @Test
    public void testNotInQuery() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.position NOT IN (3, 4)").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"13", "14", "17", "18", "19"});
    }

    @Test
    public void testNotInQueryReturnsEntityWithQueriedPropertySetToNull() throws Exception {
        List result = this.session.createQuery("from Helicopter h where h.name NOT IN ('No creative clue')").list();
        OgmAssertions.assertThat(result).onProperty("name").containsOnly(new Object[]{null, "Lama"});
    }

    @Test
    public void testParameterList() throws Exception {
        List<String> paramList = Arrays.asList("Lama", "Puma");
        List result = this.session.createQuery("from Helicopter h where h.name IN (:names)").setParameterList("names", paramList).list();
        OgmAssertions.assertThat(result).onProperty("name").containsOnly(new Object[]{"Lama"});
    }

    @Test
    public void testParameterListWithLongList() throws Exception {
        List<Long> paramList = Arrays.asList(1L, 2L, 4L);
        List result = this.session.createQuery("from Author a where a.id IN (:ids)").setParameterList("ids", paramList).list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{1L, 2L});
    }

    @Test
    public void testParameterListWithLongArray() throws Exception {
        Object[] paramArray = new Long[]{1L, 2L, 4L};
        List result = this.session.createQuery("from Author a where a.id IN (:ids)").setParameterList("ids", paramArray).list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{1L, 2L});
    }

    @Test
    public void testParameterListWithDate() throws Exception {
        ArrayList<Date> paramList = new ArrayList<Date>();
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.clear();
        calendar.set(2011, 8, 25);
        paramList.add(calendar.getTime());
        calendar.set(1, 2012);
        paramList.add(calendar.getTime());
        calendar.set(5, 1);
        paramList.add(calendar.getTime());
        List result = this.session.createQuery("from Hypothesis h where h.date IN (:dates)").setParameterList("dates", paramList).list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"13", "14"});
    }

    @Test
    public void testLikeQuery() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.description LIKE '%dimensions%'").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"13", "15"});
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.MONGODB, GridDialectType.NEO4J_EMBEDDED, GridDialectType.NEO4J_REMOTE}, comment="Querying on associated entities is not yet implemented.")
    public void testLikeQueryWithSingleCharacterWildCard() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.author.name LIKE 'al_red'").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"16"});
    }

    @Test
    public void testLikeQueryOnMultiwords() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.description LIKE 'There are more than%'").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"13", "20"});
    }

    @Test
    public void testLikeQueryOnMultiwordsNoMatch() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.description LIKE 'there are more than%'").list();
        OgmAssertions.assertThat(result).isEmpty();
    }

    @Test
    public void testLikeQueryOnMultiwordsAsPrefix() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.description LIKE '%e'").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"13", "14"});
    }

    @Test
    public void testLikeQueryOnMultiwordsPrefixed() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.description LIKE '%the cave'").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"13"});
    }

    @Test
    public void testNegatedLikeQueryOnMultiwords() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.description NOT LIKE '%out of%' and h.description LIKE '%out%'").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"17", "18"});
    }

    @Test
    public void testNotLikeQuery() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.description NOT LIKE '%dimensions%'").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"14", "16", "17", "18", "19", "20"});
    }

    @Test
    public void testIsNullQuery() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.description IS null").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"19"});
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.MONGODB, GridDialectType.NEO4J_EMBEDDED, GridDialectType.NEO4J_REMOTE}, comment="Querying on associated entities is not yet implemented.")
    public void testIsNullQueryOnPropertyOfAssociatedEntity() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.author.name IS null").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"19"});
    }

    @Test
    public void testIsNotNullQuery() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.description IS NOT null").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"13", "14", "15", "16", "17", "18", "20"});
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.MONGODB, GridDialectType.NEO4J_EMBEDDED, GridDialectType.NEO4J_REMOTE}, comment="Querying on associated entities is not yet implemented.")
    public void testIsNotNullQueryOnAssociatedEntity() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.author IS NOT null").list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"14", "16", "19"});
    }

    @Test
    public void testGetNamedQuery() throws Exception {
        Helicopter result = (Helicopter)this.session.getNamedQuery("HelicopterNameQuery").setParameter("name", (Object)"Lama").uniqueResult();
        OgmAssertions.assertThat((String)result.getName()).isEqualTo((Object)"Lama");
    }

    @Test
    public void testFirstResultAndMaxRows() throws Exception {
        List result = this.session.createQuery("from Hypothesis h where h.description IS NOT null ORDER BY id").setFirstResult(2).setMaxResults(3).list();
        OgmAssertions.assertThat(result).onProperty("id").containsOnly(new Object[]{"15", "16", "17"});
    }

    @Test
    public void testOrderedQuery() throws Exception {
        List result = this.session.createQuery("from Hypothesis h order by h.description").list();
        OgmAssertions.assertThat(result).onProperty("description").ignoreNullOrder().containsExactly(null, "Hilbert's proof of connection to 2 dimensions can be induced to reason on N dimensions", "Is the truth out there?", "Peano's curve and then Hilbert's space filling curve proof the connection from mono-dimensional to bi-dimensional space", "The truth out there.", "There are more than two dimensions over the shadows we see out of the cave", "There are more than two fools in our team.", "stuff works");
    }

    @Test
    public void testOrderedDescQuery() throws Exception {
        List result = this.session.createQuery("from Hypothesis h order by h.description desc").list();
        OgmAssertions.assertThat(result).onProperty("description").ignoreNullOrder().containsExactly("stuff works", "There are more than two fools in our team.", "There are more than two dimensions over the shadows we see out of the cave", "The truth out there.", "Peano's curve and then Hilbert's space filling curve proof the connection from mono-dimensional to bi-dimensional space", "Is the truth out there?", "Hilbert's proof of connection to 2 dimensions can be induced to reason on N dimensions", null);
    }

    @Test
    public void testOrderedDescByNumericFieldWithCustomColumnNameQuery() throws Exception {
        List result = this.session.createQuery("from Hypothesis h order by h.position desc").list();
        OgmAssertions.assertThat(result).onProperty("position").containsExactly(7, 6, 5, 4, 4, 3, 2, 1);
    }

    @Test
    public void testOrderedDescAndAscQuery() throws Exception {
        List result = this.session.createQuery("from Helicopter h order by h.make desc, h.name").list();
        OgmAssertions.assertThat(result).onProperty("make").ignoreNullOrder().containsExactly("Lama", "Lama", "Howard", "Crusoe", null);
        OgmAssertions.assertThat(result).onProperty("name").ignoreNullOrder().containsExactly("Lama", "No creative clue", null, "No creative clue", null);
    }

    @Test
    public void testProjectionWithNullValue() throws Exception {
        List<ProjectionResult> projectionResult = this.asProjectionResults("select name, make from Helicopter");
        OgmAssertions.assertThat(projectionResult).containsOnly(new Object[]{new ProjectionResult(null, null), new ProjectionResult("Lama", "Lama"), new ProjectionResult("No creative clue", "Lama"), new ProjectionResult(null, "Howard"), new ProjectionResult("No creative clue", "Crusoe")});
    }

    @Test
    public void testAutoFlushIsAppliedDuringQueryExecution() throws Exception {
        Query query = this.session.createQuery("from Hypothesis");
        this.assertQuery(this.session, 8, query);
        Hypothesis hypothesis = new Hypothesis();
        hypothesis.setId("29");
        hypothesis.setDescription("In the morning it's darker than outside");
        hypothesis.setPosition(29);
        this.session.persist((Object)hypothesis);
        if (EnumSet.of(GridDialectType.MONGODB, GridDialectType.NEO4J_EMBEDDED, GridDialectType.NEO4J_REMOTE).contains((Object)TestHelper.getCurrentDialectType())) {
            this.assertQuery(this.session, query, 9, "Auto-flush should be performed prior to query execution");
        } else {
            this.assertQuery(this.session, query, 8, "Auto-flush should not be reflected by queries executed via Hibernate Search");
        }
        this.session.delete((Object)hypothesis);
    }

    @Test
    public void testEntitiesInsertedInCurrentSessionAreFoundByQueriesNotBasedOnHibernateSearch() throws Exception {
        Query query = this.session.createQuery("from Hypothesis h where h.position = 30");
        this.assertQuery(this.session, 0, query);
        Hypothesis hypothesis = new Hypothesis();
        hypothesis.setId("30");
        hypothesis.setDescription("In the morning it's darker than outside");
        hypothesis.setPosition(30);
        this.session.persist((Object)hypothesis);
        if (TestHelper.getCurrentDialectType().supportsQueries()) {
            this.assertQuery(this.session, query, 1, "Newly inserted entity should have been flushed and returned by the query");
        } else {
            this.assertQuery(this.session, query, 0, "Newly inserted entity should not have been returned by the query");
        }
        this.session.delete((Object)hypothesis);
    }

    @Test
    public void testSetFlushModeIsApplied() throws Exception {
        Query query = this.session.createQuery("from Hypothesis h where h.position = 31");
        this.assertQuery(this.session, 0, query);
        Hypothesis hypothesis = new Hypothesis();
        hypothesis.setId("31");
        hypothesis.setDescription("In the morning it's darker than outside");
        hypothesis.setPosition(31);
        this.session.persist((Object)hypothesis);
        query.setFlushMode(FlushMode.MANUAL);
        this.assertQuery(this.session, query, 0, "No auto-flush should be performed prior to query execution");
        this.session.flush();
        if (TestHelper.getCurrentDialectType().supportsQueries()) {
            this.assertQuery(this.session, query, 1, "Flushed result should be returned by query");
        } else {
            this.assertQuery(this.session, query, 0, "Flushed result not be returned by query executed via Hibernate Search");
        }
        this.session.delete((Object)hypothesis);
    }

    @BeforeClass
    public static void insertTestEntities() throws Exception {
        Session session = sessions.openSession();
        Transaction transaction = session.beginTransaction();
        Address mainStreet = new Address();
        mainStreet.setId(1L);
        mainStreet.setCity("London");
        mainStreet.setStreet("Main Street");
        session.persist((Object)mainStreet);
        Author alfred = new Author();
        alfred.setId(1L);
        alfred.setName("alfred");
        alfred.setAddress(mainStreet);
        session.persist((Object)alfred);
        Author alma = new Author();
        alma.setId(2L);
        alma.setName("alma");
        alma.setAddress(mainStreet);
        session.persist((Object)alma);
        Author withoutName = new Author();
        withoutName.setId(3L);
        withoutName.setName(null);
        withoutName.setAddress(mainStreet);
        session.persist((Object)withoutName);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.clear();
        calendar.set(2012, 8, 25);
        Hypothesis socrates = new Hypothesis();
        socrates.setId("13");
        socrates.setDescription("There are more than two dimensions over the shadows we see out of the cave");
        socrates.setPosition(1);
        socrates.setDate(calendar.getTime());
        session.persist((Object)socrates);
        calendar.set(1, 2011);
        Hypothesis peano = new Hypothesis();
        peano.setId("14");
        peano.setDescription("Peano's curve and then Hilbert's space filling curve proof the connection from mono-dimensional to bi-dimensional space");
        peano.setPosition(2);
        peano.setDate(calendar.getTime());
        peano.setAuthor(alma);
        session.persist((Object)peano);
        calendar.set(1, 2010);
        Hypothesis sanne = new Hypothesis();
        sanne.setId("15");
        sanne.setDescription("Hilbert's proof of connection to 2 dimensions can be induced to reason on N dimensions");
        sanne.setPosition(3);
        sanne.setDate(calendar.getTime());
        session.persist((Object)sanne);
        calendar.set(1, 2009);
        Hypothesis shortOne = new Hypothesis();
        shortOne.setId("16");
        shortOne.setDescription("stuff works");
        shortOne.setPosition(4);
        shortOne.setDate(calendar.getTime());
        shortOne.setAuthor(alfred);
        session.persist((Object)shortOne);
        calendar.set(1, 2008);
        Hypothesis truth = new Hypothesis();
        truth.setId("17");
        truth.setDescription("Is the truth out there?");
        truth.setPosition(5);
        truth.setDate(calendar.getTime());
        session.persist((Object)truth);
        calendar.set(1, 2007);
        Hypothesis truthAnswer = new Hypothesis();
        truthAnswer.setId("18");
        truthAnswer.setDescription("The truth out there.");
        truthAnswer.setPosition(6);
        truthAnswer.setDate(calendar.getTime());
        session.persist((Object)truthAnswer);
        calendar.set(1, 2006);
        Hypothesis noDescription = new Hypothesis();
        noDescription.setId("19");
        noDescription.setDescription(null);
        noDescription.setAuthor(withoutName);
        noDescription.setPosition(7);
        noDescription.setDate(calendar.getTime());
        session.persist((Object)noDescription);
        Helicopter helicopter = new Helicopter();
        helicopter.setMake("Lama");
        helicopter.setName("No creative clue");
        session.persist((Object)helicopter);
        Helicopter anotherHelicopter = new Helicopter();
        anotherHelicopter.setMake("Lama");
        anotherHelicopter.setName("Lama");
        session.persist((Object)anotherHelicopter);
        Helicopter yetAnotherHelicopter = new Helicopter();
        yetAnotherHelicopter.setMake("Crusoe");
        yetAnotherHelicopter.setName("No creative clue");
        session.persist((Object)yetAnotherHelicopter);
        Helicopter evenYetAnotherHelicopter = new Helicopter();
        evenYetAnotherHelicopter.setMake("Howard");
        session.persist((Object)evenYetAnotherHelicopter);
        Helicopter helicopterWithoutName = new Helicopter();
        session.persist((Object)helicopterWithoutName);
        Hypothesis fool = new Hypothesis();
        fool.setId("20");
        fool.setDescription("There are more than two fools in our team.");
        fool.setPosition(4);
        fool.setDate(calendar.getTime());
        session.persist((Object)fool);
        transaction.commit();
        session.close();
    }

    private void assertQuery(Session session, int expectedSize, Query testedQuery) {
        List list = testedQuery.list();
        ((ListAssert)OgmAssertions.assertThat(list).as("Query failed")).hasSize(expectedSize);
    }

    private void assertQuery(Session session, Query testedQuery, int expectedSize, String message) {
        List list = testedQuery.list();
        ((ListAssert)OgmAssertions.assertThat(list).as(message)).hasSize(expectedSize);
    }

    private List<ProjectionResult> asProjectionResults(String projectionQuery) {
        List results = this.session.createQuery(projectionQuery).list();
        ArrayList<ProjectionResult> projectionResults = new ArrayList<ProjectionResult>();
        for (Object result : results) {
            if (!(result instanceof Object[])) {
                throw new IllegalArgumentException("No projection result: " + result);
            }
            projectionResults.add(ProjectionResult.forArray((Object[])result));
        }
        return projectionResults;
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Hypothesis.class, Helicopter.class, Author.class, Address.class};
    }

    private static class ProjectionResult {
        private Object[] elements;

        public ProjectionResult(Object ... elements) {
            this.elements = elements;
        }

        public static ProjectionResult forArray(Object[] element) {
            ProjectionResult result = new ProjectionResult(new Object[0]);
            result.elements = element;
            return result;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.elements);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectionResult other = (ProjectionResult)obj;
            return Arrays.equals(this.elements, other.elements);
        }

        public String toString() {
            return Arrays.deepToString(this.elements);
        }
    }
}

