/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.queries;

import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.OgmAssertions;
import org.hibernate.ogm.utils.OgmTestCase;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SimpleQueriesWithTablePerClassInheritanceTest
extends OgmTestCase {
    private Person joe = new Person("Joe");
    private CommunityMember sergey = new CommunityMember("Sergey", "Hibernate OGM");
    private Employee davide = new Employee("Davide", "Hibernate OGM", "Red Hat");

    @Before
    public void prepareDb() {
        try (OgmSession session = this.openSession();){
            Transaction tx = session.beginTransaction();
            session.persist((Object)this.joe);
            session.persist((Object)this.davide);
            session.persist((Object)this.sergey);
            session.flush();
            tx.commit();
        }
    }

    @After
    public void deleteData() {
        try (OgmSession session = this.openSession();){
            Transaction tx = session.beginTransaction();
            session.delete(session.merge((Object)this.joe));
            session.delete(session.merge((Object)this.davide));
            session.delete(session.merge((Object)this.sergey));
            session.flush();
            tx.commit();
        }
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.MONGODB, GridDialectType.NEO4J_EMBEDDED, GridDialectType.NEO4J_REMOTE})
    public void testResultsFromPerson() throws Exception {
        try (OgmSession session = this.openSession();){
            Transaction tx = session.beginTransaction();
            List results = session.createQuery("from Person p").list();
            OgmAssertions.assertThat(results).onProperty("name").containsOnly(new Object[]{this.davide.name, this.sergey.name, this.joe.name});
            tx.commit();
        }
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.MONGODB, GridDialectType.NEO4J_EMBEDDED, GridDialectType.NEO4J_REMOTE})
    public void testResultsFromCommunityMember() throws Exception {
        try (OgmSession session = this.openSession();){
            Transaction tx = session.beginTransaction();
            List results = session.createQuery("from CommunityMember c").list();
            OgmAssertions.assertThat(results).onProperty("name").containsOnly(new Object[]{this.davide.name, this.sergey.name});
            tx.commit();
        }
    }

    @Test
    public void testResultsFromEmployee() throws Exception {
        try (OgmSession session = this.openSession();){
            Transaction tx = session.beginTransaction();
            List results = session.createQuery("from Employee e").list();
            OgmAssertions.assertThat(results).onProperty("name").containsOnly(new Object[]{this.davide.name});
            tx.commit();
        }
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Person.class, CommunityMember.class, Employee.class};
    }

    @Entity(name="Employee")
    @Table(name="Employee")
    @Indexed
    public static class Employee
    extends CommunityMember {
        @Field(analyze=Analyze.NO, store=Store.YES)
        public String employer;

        public Employee() {
        }

        public Employee(String name, String project, String employer) {
            super(name, project);
            this.employer = employer;
        }

        public String getEmployer() {
            return this.employer;
        }

        public void setEmployer(String employer) {
            this.employer = employer;
        }
    }

    @Entity(name="CommunityMember")
    @Table(name="CommunityMember")
    @Indexed
    public static class CommunityMember
    extends Person {
        @Field(analyze=Analyze.NO, store=Store.YES)
        public String project;

        public CommunityMember() {
        }

        public CommunityMember(String name, String project) {
            super(name);
            this.project = project;
        }

        public String getProject() {
            return this.project;
        }

        public void setProject(String project) {
            this.project = project;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
            return result;
        }
    }

    @Entity(name="Person")
    @Table(name="Person")
    @Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
    @Indexed
    public static class Person {
        @Id
        public String name;

        public Person() {
        }

        public Person(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Person other = (Person)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

