/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.queries;

import java.util.List;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import org.hibernate.ogm.backendtck.queries.Ending;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;

@Embeddable
public class StoryBranch {
    @Field(store=Store.YES, analyze=Analyze.NO)
    private String storyText;
    @Embedded
    @IndexedEmbedded
    private Ending ending;
    @ElementCollection
    @IndexedEmbedded
    private List<Ending> additionalEndings;

    public StoryBranch() {
    }

    public StoryBranch(String embeddedString) {
        this.storyText = embeddedString;
    }

    public StoryBranch(String storyText, Ending endBranch) {
        this.storyText = storyText;
        this.ending = endBranch;
    }

    public String getStoryText() {
        return this.storyText;
    }

    public void setStoryText(String storyText) {
        this.storyText = storyText;
    }

    public Ending getEnding() {
        return this.ending;
    }

    public void setEnding(Ending anotherEmbeddable) {
        this.ending = anotherEmbeddable;
    }

    public List<Ending> getAdditionalEndings() {
        return this.additionalEndings;
    }

    public void setAdditionalEndings(List<Ending> anotherCollection) {
        this.additionalEndings = anotherCollection;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ending == null ? 0 : this.ending.hashCode());
        result = 31 * result + (this.storyText == null ? 0 : this.storyText.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StoryBranch other = (StoryBranch)obj;
        if (this.ending == null ? other.ending != null : !this.ending.equals(other.ending)) {
            return false;
        }
        return !(this.storyText == null ? other.storyText != null : !this.storyText.equals(other.storyText));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("StoryBranch [storyText=");
        builder.append(this.storyText);
        builder.append(", ending=");
        builder.append(this.ending);
        builder.append(", additionalEndings=");
        builder.append(this.additionalEndings);
        builder.append("]");
        return builder.toString();
    }
}

