/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.queries.parameters;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Type;
import org.hibernate.ogm.backendtck.queries.parameters.Genre;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.EncodingType;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.annotations.Store;

@Entity
@Indexed
public class Movie {
    @Id
    private String id;
    @Enumerated(value=EnumType.ORDINAL)
    @Field(analyze=Analyze.NO, store=Store.YES)
    private Genre genre;
    private String title;
    @Field(analyze=Analyze.NO, store=Store.YES)
    @Type(type="yes_no")
    private boolean suitableForKids;
    @Temporal(value=TemporalType.DATE)
    @Field(analyze=Analyze.NO, store=Store.YES)
    @DateBridge(encoding=EncodingType.STRING, resolution=Resolution.DAY)
    private Date releaseDate;
    @Field(analyze=Analyze.NO, store=Store.YES)
    private byte viewerRating;

    Movie() {
    }

    public Movie(String id) {
        this.id = id;
    }

    public Movie(String id, Genre genre, String title, boolean suitableForKids, Date releaseDate, byte viewerRating) {
        this.id = id;
        this.genre = genre;
        this.title = title;
        this.suitableForKids = suitableForKids;
        this.releaseDate = releaseDate;
        this.viewerRating = viewerRating;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Genre getGenre() {
        return this.genre;
    }

    public void setGenre(Genre genre) {
        this.genre = genre;
    }

    public boolean isSuitableForKids() {
        return this.suitableForKids;
    }

    public void setSuitableForKids(boolean suitableForKids) {
        this.suitableForKids = suitableForKids;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(Date releaseDate) {
        this.releaseDate = releaseDate;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public byte getViewerRating() {
        return this.viewerRating;
    }

    public void setViewerRating(byte viewerRating) {
        this.viewerRating = viewerRating;
    }
}

