/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.queries.parameters;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.List;
import javax.persistence.EntityManager;
import org.fest.assertions.Assertions;
import org.hibernate.ogm.backendtck.queries.parameters.Genre;
import org.hibernate.ogm.backendtck.queries.parameters.Movie;
import org.hibernate.ogm.utils.PackagingRule;
import org.hibernate.ogm.utils.jpa.OgmJpaTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

public class QueryWithParametersTest
extends OgmJpaTestCase {
    @Rule
    public PackagingRule packaging = new PackagingRule("persistencexml/ogm.xml", Movie.class);

    @Test
    public void canUseByteForSimpleComparison() {
        EntityManager entityManager = this.getFactory().createEntityManager();
        entityManager.getTransaction().begin();
        List thrillers = entityManager.createQuery("SELECT m FROM Movie m WHERE m.viewerRating = 8", Movie.class).getResultList();
        Assertions.assertThat((List)thrillers).onProperty("title").containsOnly(new Object[]{"To thatch a roof"});
        entityManager.getTransaction().commit();
        entityManager.close();
    }

    @Test
    public void canUseByteAsParameterForSimpleComparison() {
        EntityManager entityManager = this.getFactory().createEntityManager();
        entityManager.getTransaction().begin();
        List thrillers = entityManager.createQuery("SELECT m FROM Movie m WHERE m.viewerRating = :viewerRating", Movie.class).setParameter("viewerRating", (Object)8).getResultList();
        Assertions.assertThat((List)thrillers).onProperty("title").containsOnly(new Object[]{"To thatch a roof"});
        entityManager.getTransaction().commit();
        entityManager.close();
    }

    @Test
    public void canUseByteAsParameterForInComparison() {
        EntityManager entityManager = this.getFactory().createEntityManager();
        entityManager.getTransaction().begin();
        List thrillers = entityManager.createQuery("SELECT m FROM Movie m WHERE m.viewerRating IN (:viewerRating)", Movie.class).setParameter("viewerRating", Arrays.asList((byte)8, (byte)9)).getResultList();
        Assertions.assertThat((List)thrillers).onProperty("title").containsOnly(new Object[]{"To thatch a roof", "South by Southeast"});
        entityManager.getTransaction().commit();
        entityManager.close();
    }

    @Test
    @Ignore(value="TODO HQLPARSER-59")
    public void canUseEnumLiteralForSimpleComparison() {
        EntityManager entityManager = this.getFactory().createEntityManager();
        entityManager.getTransaction().begin();
        List thrillers = entityManager.createQuery("SELECT m FROM Movie m WHERE m.genre = org.hibernate.ogm.backendtck.queries.enums.Genre.THRILLER", Movie.class).getResultList();
        Assertions.assertThat((List)thrillers).onProperty("title").containsOnly(new Object[]{"South by Southeast", "Front Door"});
        entityManager.getTransaction().commit();
        entityManager.close();
    }

    @Test
    public void canUseEnumAsParameterForSimpleComparison() {
        EntityManager entityManager = this.getFactory().createEntityManager();
        entityManager.getTransaction().begin();
        List thrillers = entityManager.createQuery("SELECT m FROM Movie m WHERE m.genre = :genre", Movie.class).setParameter("genre", (Object)Genre.THRILLER).getResultList();
        Assertions.assertThat((List)thrillers).onProperty("title").containsOnly(new Object[]{"South by Southeast", "Front Door"});
        entityManager.getTransaction().commit();
        entityManager.close();
    }

    @Test
    public void canUseQueriesWithEnumAsParameterForInQuery() {
        EntityManager entityManager = this.getFactory().createEntityManager();
        entityManager.getTransaction().begin();
        List thrillers = entityManager.createQuery("SELECT m FROM Movie m WHERE m.genre IN (:genre)", Movie.class).setParameter("genre", EnumSet.of(Genre.DRAMA, Genre.COMEDY)).getResultList();
        Assertions.assertThat((List)thrillers).onProperty("title").containsOnly(new Object[]{"To thatch a roof", "Barnie"});
        entityManager.getTransaction().commit();
        entityManager.close();
    }

    @Test
    @Ignore(value="TODO HQLPARSER-59")
    public void canUseBooleanLiteralForSimpleComparison() {
        EntityManager entityManager = this.getFactory().createEntityManager();
        entityManager.getTransaction().begin();
        List thrillers = entityManager.createQuery("SELECT m FROM Movie m WHERE m.suitableForKids = FALSE", Movie.class).getResultList();
        Assertions.assertThat((List)thrillers).onProperty("title").containsOnly(new Object[]{"Front Door", "Barnie"});
        entityManager.getTransaction().commit();
        entityManager.close();
    }

    @Test
    public void canUseBooleanAsParameterForSimpleComparison() {
        EntityManager entityManager = this.getFactory().createEntityManager();
        entityManager.getTransaction().begin();
        List thrillers = entityManager.createQuery("SELECT m FROM Movie m WHERE m.suitableForKids = :suitable", Movie.class).setParameter("suitable", (Object)Boolean.FALSE).getResultList();
        Assertions.assertThat((List)thrillers).onProperty("title").containsOnly(new Object[]{"Front Door", "Barnie"});
        entityManager.getTransaction().commit();
        entityManager.close();
    }

    @Test
    @Ignore(value="TODO HQLPARSER-59")
    public void canUseDateLiteralForSimpleComparison() {
        EntityManager entityManager = this.getFactory().createEntityManager();
        entityManager.getTransaction().begin();
        List thrillers = entityManager.createQuery("SELECT m FROM Movie m WHERE m.releaseDate = '02 April 1958'", Movie.class).getResultList();
        Assertions.assertThat((List)thrillers).onProperty("title").containsOnly(new Object[]{"South by Southeast"});
        entityManager.getTransaction().commit();
        entityManager.close();
    }

    @Test
    public void canUseDateParameterForSimpleComparison() {
        EntityManager entityManager = this.getFactory().createEntityManager();
        entityManager.getTransaction().begin();
        List thrillers = entityManager.createQuery("SELECT m FROM Movie m WHERE m.releaseDate = :releaseDate", Movie.class).setParameter("releaseDate", (Object)new GregorianCalendar(1958, 3, 2).getTime()).getResultList();
        Assertions.assertThat((List)thrillers).onProperty("title").containsOnly(new Object[]{"South by Southeast"});
        entityManager.getTransaction().commit();
        entityManager.close();
    }

    @Before
    public void insertTestEntities() throws Exception {
        EntityManager entityManager = this.getFactory().createEntityManager();
        entityManager.getTransaction().begin();
        entityManager.persist((Object)new Movie("movie-1", Genre.COMEDY, "To thatch a roof", true, new GregorianCalendar(1955, 5, 10).getTime(), 8));
        entityManager.persist((Object)new Movie("movie-2", Genre.THRILLER, "South by Southeast", true, new GregorianCalendar(1958, 3, 2).getTime(), 9));
        entityManager.persist((Object)new Movie("movie-3", Genre.THRILLER, "Front Door", false, new GregorianCalendar(1961, 2, 23).getTime(), 7));
        entityManager.persist((Object)new Movie("movie-4", Genre.DRAMA, "Barnie", false, new GregorianCalendar(1962, 11, 2).getTime(), 7));
        entityManager.getTransaction().commit();
        entityManager.close();
    }

    @After
    public void removeTestEntities() {
        EntityManager entityManager = this.getFactory().createEntityManager();
        entityManager.getTransaction().begin();
        entityManager.remove(entityManager.find(Movie.class, (Object)"movie-1"));
        entityManager.remove(entityManager.find(Movie.class, (Object)"movie-2"));
        entityManager.remove(entityManager.find(Movie.class, (Object)"movie-3"));
        entityManager.remove(entityManager.find(Movie.class, (Object)"movie-4"));
        entityManager.getTransaction().commit();
        entityManager.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Movie.class};
    }
}

