/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.simpleentity;

import java.io.Serializable;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.simpleentity.Helicopter;
import org.hibernate.ogm.backendtck.simpleentity.Hypothesis;
import org.hibernate.ogm.utils.OgmTestCase;
import org.hibernate.ogm.utils.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class CRUDTest
extends OgmTestCase {
    @Test
    public void testSimpleCRUD() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Hypothesis hyp = new Hypothesis();
        hyp.setId("1234567890");
        hyp.setDescription("NP != P");
        hyp.setPosition(1);
        session.persist((Object)hyp);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        Hypothesis loadedHyp = (Hypothesis)session.get(Hypothesis.class, (Serializable)((Object)hyp.getId()));
        Assert.assertNotNull((String)"Cannot load persisted object", (Object)loadedHyp);
        Assert.assertEquals((String)"persist and load fails", (Object)hyp.getDescription(), (Object)loadedHyp.getDescription());
        Assert.assertEquals((String)"@Column fails", (long)hyp.getPosition(), (long)loadedHyp.getPosition());
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        loadedHyp.setDescription("P != NP");
        session.merge((Object)loadedHyp);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        Hypothesis secondLoadedHyp = (Hypothesis)session.get(Hypothesis.class, (Serializable)((Object)hyp.getId()));
        Assert.assertEquals((String)"Merge fails", (Object)loadedHyp.getDescription(), (Object)secondLoadedHyp.getDescription());
        session.delete((Object)secondLoadedHyp);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        Assert.assertNull((Object)session.get(Hypothesis.class, (Serializable)((Object)hyp.getId())));
        transaction.commit();
        session.close();
    }

    private void performanceLoop() throws Exception {
        long start = 0L;
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (i % 10000 == 0) {
                start = System.nanoTime();
            }
            this.testSimpleCRUD();
            if (i % 10000 != 9999) continue;
            long elapsed = System.nanoTime() - start;
            System.out.printf("%.3E ms for 10000 tests\n", Float.valueOf((float)elapsed / 1000000.0f));
        }
    }

    public static void main(String[] args) throws Exception {
        CRUDTest test = new CRUDTest();
        test.sessionFactory = TestHelper.getDefaultTestSessionFactory(test.getAnnotatedClasses());
        test.setUp();
        try {
            test.performanceLoop();
        }
        finally {
            test.sessionFactory.close();
        }
    }

    @Test
    public void testGeneratedValue() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Helicopter h = new Helicopter();
        h.setName("Eurocopter");
        session.persist((Object)h);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        h = (Helicopter)session.get(Helicopter.class, (Serializable)((Object)h.getUUID()));
        session.delete((Object)h);
        transaction.commit();
        session.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Hypothesis.class, Helicopter.class};
    }
}

