/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.simpleentity;

import java.io.Serializable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.simpleentity.Helicopter;
import org.hibernate.ogm.utils.OgmTestCase;
import org.junit.Assert;
import org.junit.Test;

public class NullableFieldValueTest
extends OgmTestCase {
    @Test
    public void testValueShouldBeNullWhenSetToNull() throws Exception {
        OgmSession session = this.openSession();
        String uuid = null;
        Helicopter entity = this.helicopter("Honey Bee CP3");
        Transaction tx = session.beginTransaction();
        session.persist((Object)entity);
        uuid = entity.getUUID();
        tx.commit();
        session.clear();
        Transaction tx2 = session.beginTransaction();
        Helicopter entity2 = (Helicopter)session.get(Helicopter.class, (Serializable)((Object)uuid));
        entity2.setName(null);
        tx2.commit();
        session.clear();
        tx2 = session.beginTransaction();
        entity2 = (Helicopter)session.get(Helicopter.class, (Serializable)((Object)uuid));
        session.delete((Object)entity2);
        tx2.commit();
        Assert.assertThat((Object)entity2.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        session.close();
    }

    private Helicopter helicopter(String name) {
        Helicopter entity = new Helicopter();
        entity.setName(name);
        return entity;
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Helicopter.class};
    }
}

