/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.type;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;
import java.util.UUID;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.ogm.backendtck.type.Bookmark;
import org.hibernate.ogm.utils.OgmTestCase;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class BuiltInTypeTest
extends OgmTestCase {
    private static final Random RANDOM = new Random();
    private static TimeZone originalTimeZone = null;
    private Calendar calendar;
    private Session session;
    private Bookmark bookmark;

    @BeforeClass
    public static void setDefaultTimeZone() {
        originalTimeZone = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    }

    @Before
    public void setup() {
        this.session = this.openSession();
        this.calendar = Calendar.getInstance();
        this.bookmark = new Bookmark();
    }

    @AfterClass
    public static void resetDefaultTimeZone() {
        TimeZone.setDefault(originalTimeZone);
    }

    @Test
    public void testStringSupport() throws Exception {
        this.bookmark.setDescription("Hibernate Site");
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        Assert.assertEquals((String)"String value does not match", (Object)this.bookmark.getDescription(), (Object)loadedBookmark.getDescription());
    }

    @Test
    public void testCharacterSupport() throws Exception {
        this.bookmark.setDelimiter(Character.valueOf('/'));
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        Assert.assertEquals((String)"Character value does not match", (Object)this.bookmark.getDelimiter(), (Object)loadedBookmark.getDelimiter());
    }

    @Test
    public void testIntegerSupport() throws Exception {
        this.bookmark.setStockCount(RANDOM.nextInt());
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        Assert.assertEquals((String)"Integer value does not match", (Object)this.bookmark.getStockCount(), (Object)loadedBookmark.getStockCount());
    }

    @Test
    public void testShortSupport() throws Exception {
        this.bookmark.setUrlPort((short)80);
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        Assert.assertEquals((String)"Short value does not match", (Object)this.bookmark.getUrlPort(), (Object)loadedBookmark.getUrlPort());
    }

    @Test
    public void testLongSupport() throws Exception {
        this.bookmark.setUserId(RANDOM.nextLong());
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        Assert.assertEquals((String)"Long value does not match", (Object)this.bookmark.getUserId(), (Object)loadedBookmark.getUserId());
    }

    @Test
    public void testFloatSupport() throws Exception {
        this.bookmark.setVisitRatio(Float.valueOf(10.4f));
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        Assert.assertEquals((String)"Long value does not match", (Object)this.bookmark.getVisitRatio(), (Object)loadedBookmark.getVisitRatio());
    }

    @Test
    public void testDoubleSupport() throws Exception {
        this.bookmark.setTaxPercentage(12.34);
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        Assert.assertEquals((String)"Long value does not match", (Object)this.bookmark.getTaxPercentage(), (Object)loadedBookmark.getTaxPercentage());
    }

    @Test
    public void testBooleanSupport() throws Exception {
        this.bookmark.setFavourite(Boolean.TRUE);
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        Assert.assertEquals((String)"Boolean value does not match", (Object)this.bookmark.getFavourite(), (Object)loadedBookmark.getFavourite());
    }

    @Test
    public void testTrueFalseMappedBooleanSupport() throws Exception {
        this.bookmark.setPrivate(true);
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        Assert.assertEquals((String)"Boolean value does not match", (Object)this.bookmark.isPrivate(), (Object)loadedBookmark.isPrivate());
    }

    @Test
    public void testYesNoMappedBooleanSupport() throws Exception {
        this.bookmark.setRead(true);
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        Assert.assertEquals((String)"Boolean value does not match", (Object)this.bookmark.isRead(), (Object)loadedBookmark.isRead());
    }

    @Test
    public void testNumericallyMappedBooleanSupport() throws Exception {
        this.bookmark.setShared(true);
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        Assert.assertEquals((String)"Boolean value does not match", (Object)this.bookmark.isShared(), (Object)loadedBookmark.isShared());
    }

    @Test
    public void testByteSupport() throws Exception {
        this.bookmark.setDisplayMask((byte)56);
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        Assert.assertEquals((String)"Byte value does not match", (Object)this.bookmark.getDisplayMask(), (Object)loadedBookmark.getDisplayMask());
    }

    @Test
    public void testByteArrayAsLobSupport() throws Exception {
        byte[] testData = new byte[200];
        new Random().nextBytes(testData);
        this.bookmark.setLob(testData);
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        Assert.assertArrayEquals((String)"Original and loaded data do not match!", (byte[])testData, (byte[])loadedBookmark.getLob());
    }

    @Test
    public void testLongAsLobSupport() throws Exception {
        this.bookmark.setLobWithLong(Long.MIN_VALUE);
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        Assert.assertEquals((String)"Original and loaded data do not match!", (Object)Long.MIN_VALUE, (Object)loadedBookmark.getLobWithLong());
    }

    @Test
    public void testStringAsLobSupport() throws Exception {
        String text = "Very long text ...";
        this.bookmark.setLobWithString(text);
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        Assert.assertEquals((String)"Original and loaded data do not match!", (Object)text, (Object)loadedBookmark.getLobWithString());
    }

    @Test
    public void testByteArraySupport() throws Exception {
        byte[] testData = new byte[200];
        new Random().nextBytes(testData);
        this.bookmark.setData(testData);
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        Assert.assertArrayEquals((String)"Original and loaded data do not match!", (byte[])testData, (byte[])loadedBookmark.getData());
    }

    @Test
    public void testEnumTypeMappedAsStringSupport() throws Exception {
        this.bookmark.setClassifier(Bookmark.Classifier.HOME);
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        Assert.assertEquals((String)"String mapped enum value does not match", (Object)((Object)this.bookmark.getClassifier()), (Object)((Object)loadedBookmark.getClassifier()));
    }

    @Test
    public void testEnumTypeMappedAsOrdinalSupport() throws Exception {
        this.bookmark.setClassifierAsOrdinal(Bookmark.Classifier.WORK);
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        Assert.assertEquals((String)"Ordinal mapped enum value does not match", (Object)((Object)this.bookmark.getClassifierAsOrdinal()), (Object)((Object)loadedBookmark.getClassifierAsOrdinal()));
    }

    @Test
    public void testDatePersistedAsTemporalTypeDateSupport() throws Exception {
        Date creationDate = new Date();
        this.bookmark.setCreationDate(creationDate);
        this.calendar.setTime(creationDate);
        int expectedYear = this.calendar.get(1);
        int expectedMonth = this.calendar.get(2);
        int expectedDay = this.calendar.get(5);
        int expectedTimeZoneOffset = this.calendar.getTimeZone().getRawOffset();
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        this.calendar.setTime(loadedBookmark.getCreationDate());
        int actualYear = this.calendar.get(1);
        int actualMonth = this.calendar.get(2);
        int actualDay = this.calendar.get(5);
        int actualTimeZoneOffset = this.calendar.getTimeZone().getRawOffset();
        Assert.assertEquals((String)"Year value does not match", (long)expectedYear, (long)actualYear);
        Assert.assertEquals((String)"Month value does not match", (long)expectedMonth, (long)actualMonth);
        Assert.assertEquals((String)"Day value does not match", (long)expectedDay, (long)actualDay);
        Assert.assertEquals((String)"Time zones doe not match", (long)expectedTimeZoneOffset, (long)actualTimeZoneOffset);
    }

    @Test
    public void testDatePersistedAsTemporalTypeTimeSupport() throws Exception {
        Date updateTime = new Date();
        this.bookmark.setUpdateTime(updateTime);
        this.calendar.setTime(updateTime);
        int expectedHour = this.calendar.get(11);
        int expectedMinute = this.calendar.get(12);
        int expectedSecond = this.calendar.get(13);
        int expectedTimeZoneOffset = this.calendar.getTimeZone().getRawOffset();
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        this.calendar.setTime(loadedBookmark.getUpdateTime());
        int actualHour = this.calendar.get(11);
        int actualMinute = this.calendar.get(12);
        int actualSecond = this.calendar.get(13);
        int actualTimeZoneOffset = this.calendar.getTimeZone().getRawOffset();
        Assert.assertEquals((String)"Hour value does not match", (long)expectedHour, (long)actualHour);
        Assert.assertEquals((String)"Minute value does not match", (long)expectedMinute, (long)actualMinute);
        Assert.assertEquals((String)"Second value does not match", (long)expectedSecond, (long)actualSecond);
        Assert.assertEquals((String)"Time zones doe not match", (long)expectedTimeZoneOffset, (long)actualTimeZoneOffset);
    }

    @Test
    public void testDatePersistedAsTemporalTypeTimestampSupport() throws Exception {
        Date destructionDate = new Date();
        this.bookmark.setDestructionDate(destructionDate);
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        Assert.assertEquals((String)"Year value does not match", (Object)this.bookmark.getDestructionDate(), (Object)loadedBookmark.getDestructionDate());
    }

    @Test
    public void testCalendarTemporalTypeTimestampSupport() throws Exception {
        this.bookmark.setDestructionCalendar(Calendar.getInstance());
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        Assert.assertEquals((String)"Calendar value does not match", (Object)this.bookmark.getDestructionCalendar().getTime(), (Object)loadedBookmark.getDestructionCalendar().getTime());
    }

    @Test
    public void testCalendarPersistedAsTemporalTypeDateSupport() throws Exception {
        Calendar creationCalendar = Calendar.getInstance();
        this.bookmark.setCreationCalendar(creationCalendar);
        int expectedYear = creationCalendar.get(1);
        int expectedMonth = creationCalendar.get(2);
        int expectedDay = creationCalendar.get(5);
        int expectedTimeZoneOffset = creationCalendar.getTimeZone().getRawOffset();
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        Calendar loadedCalendar = loadedBookmark.getCreationCalendar();
        int actualYear = loadedCalendar.get(1);
        int actualMonth = loadedCalendar.get(2);
        int actualDay = loadedCalendar.get(5);
        int actualTimeZoneOffset = loadedCalendar.getTimeZone().getRawOffset();
        Assert.assertEquals((String)"Year value does not match", (long)expectedYear, (long)actualYear);
        Assert.assertEquals((String)"Month value does not match", (long)expectedMonth, (long)actualMonth);
        Assert.assertEquals((String)"Day value does not match", (long)expectedDay, (long)actualDay);
        Assert.assertEquals((String)"Time zones doe not match", (long)expectedTimeZoneOffset, (long)actualTimeZoneOffset);
    }

    @Test
    public void testURLSupport() throws Exception {
        this.bookmark.setUrl(new URL("http://www.hibernate.org/"));
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        Assert.assertEquals((String)"URL value does not match", (Object)this.bookmark.getUrl(), (Object)loadedBookmark.getUrl());
    }

    @Test
    public void testUUIDSupport() throws Exception {
        UUID serialNumber = UUID.randomUUID();
        this.bookmark.setSerialNumber(serialNumber);
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        Assert.assertEquals((String)"UUID value does not match", (Object)this.bookmark.getSerialNumber(), (Object)loadedBookmark.getSerialNumber());
    }

    @Test
    public void testBigDecimalSupport() throws Exception {
        this.bookmark.setSiteWeight(new BigDecimal("21.77"));
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        Assert.assertEquals((String)"BigDecimal value does not match", (Object)this.bookmark.getSiteWeight(), (Object)loadedBookmark.getSiteWeight());
    }

    @Test
    public void testBigIntegerSupport() throws Exception {
        this.bookmark.setVisitCount(new BigInteger("444"));
        Bookmark loadedBookmark = this.saveAndGet(this.bookmark);
        Assert.assertEquals((String)"BigInteger value does not match", (Object)this.bookmark.getVisitCount(), (Object)loadedBookmark.getVisitCount());
    }

    private Bookmark saveAndGet(Bookmark bookmark) {
        Transaction transaction = this.session.beginTransaction();
        this.session.persist((Object)bookmark);
        transaction.commit();
        this.session.clear();
        transaction = this.session.beginTransaction();
        Bookmark retrievedBookmark = (Bookmark)this.session.get(Bookmark.class, (Serializable)((Object)bookmark.getId()));
        transaction.commit();
        return retrievedBookmark;
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Bookmark.class};
    }
}

