/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.type.converter;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.OgmSessionFactory;
import org.hibernate.ogm.backendtck.type.converter.MyString;
import org.hibernate.ogm.backendtck.type.converter.OtherPrinter;
import org.hibernate.ogm.backendtck.type.converter.Printer;
import org.hibernate.ogm.cfg.OgmConfiguration;
import org.hibernate.ogm.model.impl.DefaultEntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.type.spi.TypeTranslator;
import org.hibernate.ogm.utils.OgmTestCase;
import org.hibernate.ogm.utils.TestHelper;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.junit.Test;

public class JpaAttributeConverterTest
extends OgmTestCase {
    @Test
    public void jpaConverterIsApplied() throws Exception {
        OgmSession session = this.openSession();
        session.getTransaction().begin();
        Printer printer = new Printer();
        printer.name = "somefoo";
        Assertions.assertThat((String)printer.name).isEqualTo((Object)"somefoo");
        session.persist((Object)printer);
        session.getTransaction().commit();
        session.clear();
        session.getTransaction().begin();
        Map<String, Object> persistedTuple = TestHelper.extractEntityTuple((Session)session, this.getPrinterEntityKey(printer.id));
        String persistedPrinterName = (String)persistedTuple.get("name");
        Assertions.assertThat((String)persistedPrinterName).isEqualTo((Object)"SOMEFOO");
        session.getTransaction().commit();
        session.clear();
        session.getTransaction().begin();
        printer = (Printer)session.get(Printer.class, (Serializable)printer.id);
        Assertions.assertThat((Object)printer).isNotNull();
        Assertions.assertThat((String)printer.name).isEqualTo((Object)"somefoo");
        session.delete((Object)printer);
        session.getTransaction().commit();
        session.close();
    }

    @Test
    public void jpaConverterIsAppliedToCustomType() throws Exception {
        OgmSession session = this.openSession();
        session.getTransaction().begin();
        Printer printer = new Printer();
        printer.brand = new MyString("printr inc.");
        Assertions.assertThat((String)printer.brand.toString()).isEqualTo((Object)"printr inc.");
        session.persist((Object)printer);
        session.getTransaction().commit();
        session.clear();
        session.getTransaction().begin();
        Map<String, Object> persistedTuple = TestHelper.extractEntityTuple((Session)session, this.getPrinterEntityKey(printer.id));
        String persistedPrinterName = (String)persistedTuple.get("brand");
        Assertions.assertThat((String)persistedPrinterName).isEqualTo((Object)"PRINTR INC.");
        session.getTransaction().commit();
        session.clear();
        session.getTransaction().begin();
        printer = (Printer)session.get(Printer.class, (Serializable)printer.id);
        Assertions.assertThat((Object)printer).isNotNull();
        Assertions.assertThat((String)printer.brand.toString()).isEqualTo((Object)"printr inc.");
        session.delete((Object)printer);
        session.getTransaction().commit();
        session.close();
    }

    @Test
    public void testGridTypeForIntermediaryTypeNotSupported() throws Exception {
        OgmConfiguration cfg = new OgmConfiguration();
        cfg.addAnnotatedClass(OtherPrinter.class);
        try {
            OgmSessionFactory sf = cfg.buildSessionFactory();
            sf.close();
            Assertions.assertThat((boolean)false).as("We should fail as the AttributeConverter is not supported");
        }
        catch (Exception e) {
            Assertions.assertThat((String)e.getCause().getCause().getMessage()).startsWith("OGM000084");
        }
    }

    private EntityKey getPrinterEntityKey(UUID id) {
        GridType uuidType = ((TypeTranslator)((SessionFactoryImplementor)this.sessionFactory).getServiceRegistry().getService(TypeTranslator.class)).getType((Type)StandardBasicTypes.UUID_BINARY);
        Tuple dummy = new Tuple();
        uuidType.nullSafeSet(dummy, (Object)id, new String[]{"id"}, null);
        return new EntityKey((EntityKeyMetadata)new DefaultEntityKeyMetadata("Printer", new String[]{"id"}), new Object[]{dummy.get("id")});
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Printer.class};
    }
}

