/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.util.impl;

import java.util.ArrayList;
import java.util.Arrays;
import org.fest.assertions.Assertions;
import org.hibernate.ogm.util.impl.ArrayHelper;
import org.junit.Assert;
import org.junit.Test;

public class ArrayHelperTest {
    @Test
    public void testToStringArray() {
        Assert.assertArrayEquals((Object[])new String[]{"1", "2"}, (Object[])ArrayHelper.toStringArray(Arrays.asList("1", "2")));
    }

    @Test
    public void testTo2DStringArray() {
        ArrayList<String[]> keyColumns = new ArrayList<String[]>();
        keyColumns.add(new String[]{"col1", "col2"});
        keyColumns.add(new String[]{"col3", "col4", "col5"});
        keyColumns.add(new String[]{"col1"});
        String[][] expectedArr = new String[][]{(String[])keyColumns.get(0), (String[])keyColumns.get(1), (String[])keyColumns.get(2)};
        String[][] resultArr = ArrayHelper.to2DStringArray(keyColumns);
        Assertions.assertThat((Object[])resultArr).isEqualTo((Object[])expectedArr);
    }

    @Test
    public void testSlice() {
        String[] strings = new String[]{"1", "2", "3"};
        int begin = 0;
        int length = 2;
        Object[] expResult = new String[]{"1", "2"};
        Object[] result = ArrayHelper.slice((String[])strings, (int)begin, (int)length);
        Assert.assertArrayEquals((Object[])expResult, (Object[])result);
    }

    @Test
    public void testIndexOf() {
        Object[] array = new Integer[]{1, 2, 3};
        Integer element = 3;
        int expResult = 2;
        int result = ArrayHelper.indexOf((Object[])array, (Object)element);
        Assert.assertEquals((long)expResult, (long)result);
    }

    @Test
    public void testContains() {
        Object[] array = new Integer[]{1, 2, 3};
        Integer element = 3;
        boolean expResult = true;
        boolean result = ArrayHelper.contains((Object[])array, (Object)element);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testConcat() {
        Object[] first = new String[]{"1", "2"};
        Object[] second = new String[]{"3"};
        Object[] expResult = new String[]{"1", "2", "3"};
        Object[] result = ArrayHelper.concat((Object[])first, (Object[])second);
        Assert.assertArrayEquals((Object[])expResult, (Object[])result);
    }
}

