/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.utils;

import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.utils.TestHelper;

public enum GridDialectType {
    HASHMAP("org.hibernate.ogm.datastore.map.impl.MapDialect", false, false),
    INFINISPAN("org.hibernate.ogm.datastore.infinispan.InfinispanDialect", false, false),
    INFINISPAN_REMOTE("org.hibernate.ogm.datastore.infinispanremote.InfinispanRemoteDialect", true, false),
    EHCACHE("org.hibernate.ogm.datastore.ehcache.EhcacheDialect", false, false),
    MONGODB("org.hibernate.ogm.datastore.mongodb.MongoDBDialect", true, true),
    NEO4J_EMBEDDED("org.hibernate.ogm.datastore.neo4j.EmbeddedNeo4jDialect", false, true),
    NEO4J_REMOTE("org.hibernate.ogm.datastore.neo4j.RemoteNeo4jDialect", false, true),
    COUCHDB("org.hibernate.ogm.datastore.couchdb.CouchDBDialect", true, false),
    CASSANDRA("org.hibernate.ogm.datastore.cassandra.CassandraDialect", false, false),
    REDIS_JSON("org.hibernate.ogm.datastore.redis.RedisJsonDialect", false, false),
    REDIS_HASH("org.hibernate.ogm.datastore.redis.RedisHashDialect", false, false);

    private final String dialectClassName;
    private final boolean isDocumentStore;
    private final boolean supportsQueries;

    private GridDialectType(String dialectClassName, boolean isDocumentStore, boolean supportsQueries) {
        this.dialectClassName = dialectClassName;
        this.isDocumentStore = isDocumentStore;
        this.supportsQueries = supportsQueries;
    }

    public Class<? extends GridDialect> loadGridDialectClass() {
        return TestHelper.loadClass(this.dialectClassName);
    }

    public boolean isDocumentStore() {
        return this.isDocumentStore;
    }

    public boolean supportsQueries() {
        return this.supportsQueries;
    }
}

