/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.utils;

import java.util.Map;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.ogm.datastore.document.options.AssociationStorageType;
import org.hibernate.ogm.datastore.map.MapDatastore;
import org.hibernate.ogm.datastore.map.impl.MapDatastoreProvider;
import org.hibernate.ogm.datastore.map.impl.MapDialect;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.utils.GridDialectTestHelper;

public class HashMapTestHelper
implements GridDialectTestHelper {
    @Override
    public long getNumberOfEntities(Session session) {
        return this.getNumberOfEntities(session.getSessionFactory());
    }

    @Override
    public long getNumberOfEntities(SessionFactory sessionFactory) {
        return HashMapTestHelper.getEntityMap(sessionFactory).size();
    }

    @Override
    public long getNumberOfAssociations(Session session) {
        return this.getNumberOfAssociations(session.getSessionFactory());
    }

    @Override
    public long getNumberOfAssociations(SessionFactory sessionFactory) {
        return HashMapTestHelper.getAssociationCache(sessionFactory).size();
    }

    @Override
    public Map<String, Object> extractEntityTuple(Session session, EntityKey key) {
        return HashMapTestHelper.getEntityMap(session.getSessionFactory()).get(key);
    }

    private static Map<EntityKey, Map<String, Object>> getEntityMap(SessionFactory sessionFactory) {
        MapDatastoreProvider castProvider = HashMapTestHelper.getProvider(sessionFactory);
        return castProvider.getEntityMap();
    }

    private static MapDatastoreProvider getProvider(SessionFactory sessionFactory) {
        DatastoreProvider provider = (DatastoreProvider)((SessionFactoryImplementor)sessionFactory).getServiceRegistry().getService(DatastoreProvider.class);
        if (!MapDatastoreProvider.class.isInstance(provider)) {
            throw new RuntimeException("Not testing with MapDatastoreProvider, cannot extract underlying map");
        }
        return (MapDatastoreProvider)MapDatastoreProvider.class.cast(provider);
    }

    private static Map<AssociationKey, Map<RowKey, Map<String, Object>>> getAssociationCache(SessionFactory sessionFactory) {
        MapDatastoreProvider castProvider = HashMapTestHelper.getProvider(sessionFactory);
        return castProvider.getAssociationsMap();
    }

    @Override
    public boolean backendSupportsTransactions() {
        return false;
    }

    @Override
    public void dropSchemaAndDatabase(SessionFactory sessionFactory) {
    }

    @Override
    public Map<String, String> getEnvironmentProperties() {
        return null;
    }

    @Override
    public long getNumberOfAssociations(SessionFactory sessionFactory, AssociationStorageType type) {
        throw new UnsupportedOperationException("This datastore does not support different association storage strategies.");
    }

    @Override
    public GridDialect getGridDialect(DatastoreProvider datastoreProvider) {
        return new MapDialect((MapDatastoreProvider)datastoreProvider);
    }

    public Class<MapDatastore> getDatastoreConfigurationType() {
        return MapDatastore.class;
    }
}

