/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.utils;

import java.io.File;
import java.net.URL;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;

public class IndexDirectoryManager {
    private static final Log log = LoggerFactory.make();

    public static File getTargetDir(Class<?> testClass) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        String currentTestClass = testClass.getName();
        int hopsToCompileDirectory = currentTestClass.split("\\.").length;
        int hopsToTargetDirectory = hopsToCompileDirectory + 1;
        URL classURL = contextClassLoader.getResource(currentTestClass.replace('.', '/') + ".class");
        File targetDir = new File(classURL.getFile());
        for (int i = 0; i < hopsToTargetDirectory; ++i) {
            targetDir = targetDir.getParentFile();
        }
        return targetDir;
    }

    public static String getIndexDirectory(Class<?> testClass) {
        File targetDir = IndexDirectoryManager.getTargetDir(testClass);
        String indexDirPath = targetDir.getAbsolutePath() + File.separator + "indextemp";
        log.debugf("Using %s as index directory.", (Object)indexDirPath);
        return indexDirPath;
    }
}

