/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.utils;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.dialect.batch.spi.GroupedChangesToEntityOperation;
import org.hibernate.ogm.dialect.batch.spi.InsertOrUpdateAssociationOperation;
import org.hibernate.ogm.dialect.batch.spi.InsertOrUpdateTupleOperation;
import org.hibernate.ogm.dialect.batch.spi.Operation;
import org.hibernate.ogm.dialect.batch.spi.OperationsQueue;
import org.hibernate.ogm.dialect.batch.spi.RemoveAssociationOperation;
import org.hibernate.ogm.dialect.batch.spi.RemoveTupleOperation;
import org.hibernate.ogm.dialect.impl.ForwardingGridDialect;
import org.hibernate.ogm.dialect.query.spi.BackendQuery;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.query.spi.QueryParameters;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.OperationContext;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.entityentry.impl.TuplePointer;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.util.impl.StringHelper;
import org.hibernate.ogm.utils.TestHelper;

public class InvokedOperationsLoggingDialect
extends ForwardingGridDialect<Serializable> {
    private static final String PATH = "invocations.log";
    private final boolean writeFile = false;
    private int opIndex = 0;
    private Path file;
    private final List<String> operations = new ArrayList<String>();

    public InvokedOperationsLoggingDialect(DatastoreProvider provider) {
        super(TestHelper.getCurrentGridDialect(provider));
    }

    public List<String> getOperations() {
        return Collections.unmodifiableList(this.operations);
    }

    public void reset() {
        this.operations.clear();
    }

    public Tuple getTuple(EntityKey key, OperationContext operationContext) {
        Tuple tuple = super.getTuple(key, operationContext);
        this.log("getTuple", key.toString(), tuple != null ? tuple.toString() : "null");
        return tuple;
    }

    public List<Tuple> getTuples(EntityKey[] keys, TupleContext tupleContext) {
        List tuples = super.getTuples(keys, tupleContext);
        this.log("getTuples", Arrays.toString(keys), tuples != null ? tuples.toString() : "null");
        return tuples;
    }

    public Tuple createTuple(EntityKey key, OperationContext operationContext) {
        Tuple tuple = super.createTuple(key, operationContext);
        this.log("createTuple", key.toString(), tuple != null ? tuple.toString() : "null");
        return tuple;
    }

    public void insertOrUpdateTuple(EntityKey key, TuplePointer tuplePointer, TupleContext tupleContext) {
        super.insertOrUpdateTuple(key, tuplePointer, tupleContext);
        this.log("insertOrUpdateTuple", key.toString() + ", " + tuplePointer.toString(), "VOID");
    }

    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        super.removeTuple(key, tupleContext);
        this.log("removeTuple", key.toString(), "VOID");
    }

    public Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        Association association = super.getAssociation(key, associationContext);
        this.log("getAssociation", key.toString(), this.toShortString(association));
        return association;
    }

    public Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        Association association = super.createAssociation(key, associationContext);
        this.log("createAssociation", key.toString(), this.toShortString(association));
        return association;
    }

    public void insertOrUpdateAssociation(AssociationKey key, Association association, AssociationContext associationContext) {
        super.insertOrUpdateAssociation(key, association, associationContext);
        this.log("insertOrUpdateAssociation", key.toString() + ", " + this.toShortString(association), "VOID");
    }

    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        super.removeAssociation(key, associationContext);
        this.log("removeAssociation", key.toString(), "VOID");
    }

    public boolean updateTupleWithOptimisticLock(EntityKey entityKey, Tuple oldLockState, Tuple tuple, TupleContext tupleContext) {
        boolean success = super.updateTupleWithOptimisticLock(entityKey, oldLockState, tuple, tupleContext);
        this.log("updateTuple", entityKey.toString() + ", " + tuple.toString(), String.valueOf(success));
        return success;
    }

    public boolean removeTupleWithOptimisticLock(EntityKey entityKey, Tuple oldLockState, TupleContext tupleContext) {
        boolean success = super.removeTupleWithOptimisticLock(entityKey, oldLockState, tupleContext);
        this.log("removeTuple", entityKey.toString(), String.valueOf(success));
        return success;
    }

    public Tuple createTuple(EntityKeyMetadata entityKeyMetadata, OperationContext operationContext) {
        return super.createTuple(entityKeyMetadata, operationContext);
    }

    public void insertTuple(EntityKeyMetadata entityKeyMetadata, Tuple tuple, TupleContext tupleContext) {
        super.insertTuple(entityKeyMetadata, tuple, tupleContext);
        this.log("insertTuple", entityKeyMetadata.toString() + ", " + tuple.toString(), "VOID");
    }

    public ClosableIterator<Tuple> executeBackendQuery(BackendQuery<Serializable> query, QueryParameters queryParameters, TupleContext tupleContext) {
        ClosableIterator result = super.executeBackendQuery(query, queryParameters, tupleContext);
        this.log("executeBackendQuery", query.toString() + ", " + queryParameters.toString(), "tbd.");
        return result;
    }

    public void executeBatch(OperationsQueue queue) {
        OperationsQueue newQueue = new OperationsQueue();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> subOperations = new ArrayList<String>();
        if (!queue.isClosed()) {
            Operation operation = queue.poll();
            while (operation != null) {
                newQueue.add(operation);
                if (operation instanceof GroupedChangesToEntityOperation) {
                    ArrayList<String> groupedOperations = new ArrayList<String>();
                    sb.append("group[");
                    for (Operation groupedOperation : ((GroupedChangesToEntityOperation)operation).getOperations()) {
                        if (!groupedOperations.isEmpty()) {
                            sb.append(", ");
                        }
                        this.appendSimpleOperation(sb, groupedOperations, groupedOperation);
                    }
                    sb.append("]");
                    subOperations.add("group[" + StringHelper.join(groupedOperations, (String)",") + "]");
                } else {
                    this.appendSimpleOperation(sb, subOperations, operation);
                }
                if ((operation = queue.poll()) == null) continue;
                sb.append(", ");
            }
        }
        super.executeBatch(newQueue);
        this.log("executeBatch[" + StringHelper.join(subOperations, (String)",") + "]", sb.toString(), "VOID");
    }

    private void appendSimpleOperation(StringBuilder log, List<String> subOperations, Operation operation) {
        if (operation instanceof InsertOrUpdateTupleOperation) {
            log.append("InsertOrUpdateTuple(").append(((InsertOrUpdateTupleOperation)operation).getEntityKey()).append(" )");
            subOperations.add("insertOrUpdateTuple");
        } else if (operation instanceof RemoveTupleOperation) {
            log.append("RemoveTuple(").append(((RemoveTupleOperation)operation).getEntityKey()).append(" )");
            subOperations.add("removeTuple");
        } else if (operation instanceof InsertOrUpdateAssociationOperation) {
            log.append("InsertOrUpdateAssociation(").append(((InsertOrUpdateAssociationOperation)operation).getAssociationKey()).append(" )");
            subOperations.add("insertOrUpdateAssociation");
        } else if (operation instanceof RemoveAssociationOperation) {
            log.append("RemoveAssociation(").append(((RemoveAssociationOperation)operation).getAssociationKey()).append(" )");
            subOperations.add("removeAssociation");
        }
    }

    private void log(String operation, String parameters, String returnValue) {
        this.operations.add(operation);
    }

    private String toShortString(Association association) {
        if (association == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("Association[");
        Iterator rowKeys = association.getKeys().iterator();
        while (rowKeys.hasNext()) {
            RowKey rowKey = (RowKey)rowKeys.next();
            sb.append(this.toShortString(rowKey)).append("=").append(this.toShortString(association.get(rowKey)));
            if (!rowKeys.hasNext()) continue;
            sb.append(",").append(StringHelper.lineSeparator());
        }
        sb.append("]");
        return sb.toString();
    }

    private String toShortString(RowKey rowKey) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int i = 0;
        for (String column : rowKey.getColumnNames()) {
            sb.append(column).append("=").append(rowKey.getColumnValue(column));
            if (++i >= rowKey.getColumnNames().length) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    private String toShortString(Tuple tuple) {
        StringBuilder sb = new StringBuilder("(");
        int i = 0;
        for (String column : tuple.getColumnNames()) {
            sb.append(column).append("=").append(tuple.get(column));
            if (++i >= tuple.getColumnNames().size()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    private void resetFile() {
        this.file = Paths.get(PATH, new String[0]);
        try {
            if (!Files.exists(this.file, new LinkOption[0])) {
                this.file = Files.createFile(this.file, new FileAttribute[0]);
            }
            Files.write(this.file, ("#\top\tparameters\tresult" + System.lineSeparator()).getBytes(), StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

