/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.utils;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.ogm.OgmSessionFactory;
import org.hibernate.ogm.utils.TestHelper;
import org.junit.rules.ExternalResource;

public class OgmSessionFactoryRule
extends ExternalResource {
    private final Class<?>[] entityTypes;
    private final Map<String, Object> configurationSettings = new HashMap<String, Object>();
    private OgmSessionFactory factory;

    public OgmSessionFactoryRule(Class<?> ... entityTypes) {
        this.entityTypes = entityTypes;
    }

    public synchronized OgmSessionFactoryRule setConfigurationProperty(String key, Object value) {
        if (this.factory != null) {
            throw new IllegalStateException("Can not set configuration after the SessionFactory was started");
        }
        this.configurationSettings.put(key, value);
        return this;
    }

    public synchronized OgmSessionFactory getOgmSessionFactory() {
        if (this.factory == null) {
            throw new IllegalStateException("OgmSessionFactory was not successfully started");
        }
        return this.factory;
    }

    public synchronized void before() throws Exception {
        if (this.factory != null) {
            throw new IllegalStateException("Duplicate start?");
        }
        this.factory = TestHelper.getDefaultTestSessionFactory(this.configurationSettings, this.entityTypes);
    }

    public synchronized void after() {
        if (this.factory != null) {
            this.factory.close();
            this.factory = null;
        }
    }
}

