/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.fest.assertions.Assertions;
import org.fest.assertions.LongAssert;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.OgmSessionFactory;
import org.hibernate.ogm.engine.spi.OgmSessionFactoryImplementor;
import org.hibernate.ogm.utils.OgmTestRunner;
import org.hibernate.ogm.utils.TestEntities;
import org.hibernate.ogm.utils.TestHelper;
import org.hibernate.ogm.utils.TestSessionFactory;
import org.hibernate.ogm.utils.TestSessionFactoryConfiguration;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;

@RunWith(value=OgmTestRunner.class)
public abstract class OgmTestCase {
    @TestSessionFactory
    protected OgmSessionFactory sessionFactory;
    private List<Session> openedSessions;

    @TestEntities
    private Class<?>[] getTestEntities() {
        return this.getAnnotatedClasses();
    }

    protected abstract Class<?>[] getAnnotatedClasses();

    @TestSessionFactoryConfiguration
    private void modifyConfiguration(Map<String, Object> cfg) {
        this.configure(cfg);
    }

    protected void configure(Map<String, Object> cfg) {
    }

    protected OgmSession openSession() {
        OgmSession session = this.sessionFactory.openSession();
        this.openedSessions.add((Session)session);
        return session;
    }

    @Before
    public void setUp() {
        this.openedSessions = new ArrayList<Session>();
    }

    @After
    public void closeOpenedSessions() {
        for (Session session : this.openedSessions) {
            if (!session.isOpen()) continue;
            Transaction transaction = session.getTransaction();
            if (transaction != null && transaction.getStatus() == TransactionStatus.ACTIVE) {
                transaction.rollback();
            }
            session.close();
        }
    }

    protected OgmSessionFactoryImplementor getSessionFactory() {
        return (OgmSessionFactoryImplementor)this.sessionFactory;
    }

    protected void checkCleanCache() {
        ((LongAssert)Assertions.assertThat((long)TestHelper.getNumberOfEntities((SessionFactory)this.sessionFactory)).as("Entity cache should be empty")).isEqualTo(0L);
        ((LongAssert)Assertions.assertThat((long)TestHelper.getNumberOfAssociations((SessionFactory)this.sessionFactory)).as("Association cache should be empty")).isEqualTo(0L);
    }
}

