/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.utils;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.fest.assertions.Assertions;
import org.fest.assertions.ListAssert;

public class OrderedListAssert
extends ListAssert {
    private final boolean ignoringNullPosition;

    protected OrderedListAssert(List<?> actual) {
        this(actual, false);
    }

    private OrderedListAssert(List<?> actual, boolean ignoreNullPosition) {
        super(actual);
        this.ignoringNullPosition = ignoreNullPosition;
    }

    public OrderedListAssert ignoreNullOrder() {
        return new OrderedListAssert((List)this.actual, true);
    }

    public OrderedListAssert onProperty(String propertyName) {
        this.isNotNull();
        if (((List)this.actual).isEmpty()) {
            return new OrderedListAssert(Collections.emptyList());
        }
        return new OrderedListAssert(this.getProjection((List)this.actual, propertyName));
    }

    public OrderedListAssert containsExactly(Object ... expected) {
        if (this.ignoringNullPosition) {
            Assertions.assertThat((List)((List)this.actual)).hasSize(expected.length);
            List<Object> actualWithoutNull = OrderedListAssert.trimNull((List)this.actual);
            List<Object> expectedWithoutNull = OrderedListAssert.trimNull(Arrays.asList(expected));
            Assertions.assertThat(actualWithoutNull).isEqualTo(expectedWithoutNull);
            if (((List)this.actual).size() > 1 && actualWithoutNull.size() > 0 && ((List)this.actual).get(0) == null && ((List)this.actual).get(((List)this.actual).size() - 1) == null) {
                throw this.failure("Null order should be consistent: " + this.actual);
            }
        } else {
            super.containsExactly(expected);
        }
        return this;
    }

    private static List<Object> trimNull(List<?> original) {
        ArrayList<Object> trimmed = new ArrayList<Object>();
        int last = OrderedListAssert.findLastNonNullValuePosition(original);
        int i = -1;
        boolean skipNulls = true;
        while (i < last) {
            Object object = original.get(++i);
            if (!skipNulls) {
                trimmed.add(object);
                continue;
            }
            if (!skipNulls || object == null) continue;
            skipNulls = false;
            trimmed.add(object);
        }
        return trimmed;
    }

    private static int findLastNonNullValuePosition(List<?> actualWithNull) {
        for (int last = actualWithNull.size() - 1; last > 0; --last) {
            if (actualWithNull.get(last) == null) continue;
            return last;
        }
        return -1;
    }

    private List<Object> getProjection(List<?> source, String propertyName) {
        ArrayList<Object> projection = new ArrayList<Object>(source.size());
        for (Object object : source) {
            projection.add(this.getPropertyValue(object, propertyName));
        }
        return projection;
    }

    private Object getPropertyValue(Object object, String propertyName) {
        try {
            PropertyDescriptor[] properties;
            BeanInfo info = Introspector.getBeanInfo(object.getClass());
            for (PropertyDescriptor property : properties = info.getPropertyDescriptors()) {
                if (!property.getName().equals(propertyName)) continue;
                return property.getReadMethod().invoke(object, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new IllegalArgumentException("No property " + propertyName + " exists in " + object.getClass());
    }
}

