/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.utils;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.rules.TemporaryFolder;

public class PackagingRule
extends TemporaryFolder {
    protected static ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
    private static final ArchivePath persistencePath = ArchivePaths.create((String)"persistence.xml");
    private final JavaArchive archive;
    private final File testPackage;
    private final URLClassLoader classLoader;

    public PackagingRule(String persistenceConfResource, Class<?> ... entities) {
        try {
            this.create();
            this.archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"jtastandalone.jar");
            this.archive.addClasses((Class[])entities);
            this.archive.addAsManifestResource(persistenceConfResource, persistencePath);
            this.testPackage = this.newFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ((ZipExporter)this.archive.as(ZipExporter.class)).exportTo(this.testPackage, true);
        try {
            URL url = this.testPackage.toURL();
            this.classLoader = new URLClassLoader(new URL[]{url}, originalClassLoader);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void before() throws Throwable {
        super.before();
        Thread.currentThread().setContextClassLoader(this.classLoader);
    }

    public void after() {
        Thread.currentThread().setContextClassLoader(originalClassLoader);
        try {
            this.classLoader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.after();
    }
}

