/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

public class SessionHelper {
    public static void persist(SessionFactory sessions, Object ... entities) {
        Session session = sessions.openSession();
        SessionHelper.persist(session, entities);
    }

    public static void persist(Session session, Object ... entities) {
        Transaction transaction = session.beginTransaction();
        for (Object entity : entities) {
            session.persist(entity);
        }
        transaction.commit();
        session.close();
    }

    public static void delete(SessionFactory sessions, Class<?> entityClass, Serializable ... ids) {
        Session session = sessions.openSession();
        Transaction transaction = session.beginTransaction();
        for (Serializable id : ids) {
            session.delete(session.load(entityClass, id));
        }
        transaction.commit();
        session.close();
    }

    public static List<ProjectionResult> asProjectionResults(Session session, String projectionQuery) {
        List results = session.createQuery(projectionQuery).list();
        ArrayList<ProjectionResult> projectionResults = new ArrayList<ProjectionResult>();
        for (Object result : results) {
            if (!(result instanceof Object[])) {
                throw new IllegalArgumentException("No projection result: " + result);
            }
            projectionResults.add(ProjectionResult.forArray((Object[])result));
        }
        return projectionResults;
    }

    public static class ProjectionResult {
        private Object[] elements;

        public ProjectionResult(Object ... elements) {
            this.elements = elements;
        }

        public static ProjectionResult forArray(Object[] element) {
            ProjectionResult result = new ProjectionResult(new Object[0]);
            result.elements = element;
            return result;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.elements);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectionResult other = (ProjectionResult)obj;
            return Arrays.equals(this.elements, other.elements);
        }

        public String toString() {
            return Arrays.deepToString(this.elements);
        }
    }
}

