/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.utils;

import org.hibernate.ogm.datastore.impl.DatastoreProviderType;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.SkipByDatastoreProvider;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.hibernate.ogm.utils.TestHelper;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

public class SkippableTestRunner
extends BMUnitRunner {
    public SkippableTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    public void run(RunNotifier notifier) {
        if (this.isTestClassSkipped() || this.areAllTestMethodsSkipped()) {
            this.skipTest(notifier);
        } else {
            super.run(notifier);
        }
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        if (this.isTestMethodSkipped(method)) {
            this.skipTest(method, notifier);
        } else {
            super.runChild(method, notifier);
        }
    }

    protected void skipTest(RunNotifier notifier) {
        notifier.fireTestIgnored(Description.createSuiteDescription((Class)super.getTestClass().getJavaClass()));
    }

    protected void skipTest(FrameworkMethod method, RunNotifier notifier) {
        notifier.fireTestIgnored(this.describeChild(method));
    }

    protected boolean isTestClassSkipped() {
        return this.isTestClassSkippedByDatastoreProvider() || this.isTestClassSkippedByGridDialect();
    }

    private boolean isTestClassSkippedByDatastoreProvider() {
        SkipByDatastoreProvider skipByDatastoreProvider = this.getTestClass().getJavaClass().getAnnotation(SkipByDatastoreProvider.class);
        return skipByDatastoreProvider != null ? this.isSkipped(skipByDatastoreProvider) : false;
    }

    private boolean isTestClassSkippedByGridDialect() {
        SkipByGridDialect skipByGridDialect = this.getTestClass().getJavaClass().getAnnotation(SkipByGridDialect.class);
        return skipByGridDialect != null ? this.isSkipped(skipByGridDialect) : false;
    }

    protected boolean isTestMethodSkipped(FrameworkMethod method) {
        if (this.isTestMethodSkippedByDatastoreProvider(method) || this.isTestMethodSkippedByGridDialect(method)) {
            return true;
        }
        return this.isTestClassSkipped();
    }

    private boolean isTestMethodSkippedByDatastoreProvider(FrameworkMethod method) {
        SkipByDatastoreProvider skipByDatastoreProvider = (SkipByDatastoreProvider)method.getAnnotation(SkipByDatastoreProvider.class);
        return skipByDatastoreProvider != null ? this.isSkipped(skipByDatastoreProvider) : false;
    }

    private boolean isTestMethodSkippedByGridDialect(FrameworkMethod method) {
        SkipByGridDialect skipByGridDialect = (SkipByGridDialect)method.getAnnotation(SkipByGridDialect.class);
        return skipByGridDialect != null ? this.isSkipped(skipByGridDialect) : false;
    }

    protected boolean areAllTestMethodsSkipped() {
        for (FrameworkMethod method : this.getChildren()) {
            if (this.isTestMethodSkipped(method)) continue;
            return false;
        }
        return true;
    }

    private boolean isSkipped(SkipByDatastoreProvider skipByDatastoreProvider) {
        for (DatastoreProviderType datastoreProvider : skipByDatastoreProvider.value()) {
            if (datastoreProvider != TestHelper.getCurrentDatastoreProviderType()) continue;
            return true;
        }
        return false;
    }

    private boolean isSkipped(SkipByGridDialect skipByGridDialect) {
        Class<? extends GridDialect> actualGridDialectClass = TestHelper.getCurrentGridDialectClass();
        for (GridDialectType gridDialectType : skipByGridDialect.value()) {
            Class<? extends GridDialect> gridDialectClass = gridDialectType.loadGridDialectClass();
            if (gridDialectClass == null || !gridDialectClass.isAssignableFrom(actualGridDialectClass)) continue;
            return true;
        }
        return false;
    }
}

