/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.utils;

import com.arjuna.ats.arjuna.coordinator.TxControl;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.fest.assertions.Assertions;
import org.fest.assertions.LongAssert;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.jpa.HibernateEntityManagerFactory;
import org.hibernate.ogm.OgmSessionFactory;
import org.hibernate.ogm.boot.OgmSessionFactoryBuilder;
import org.hibernate.ogm.cfg.impl.ConfigurableImpl;
import org.hibernate.ogm.datastore.document.options.AssociationStorageType;
import org.hibernate.ogm.datastore.impl.DatastoreProviderType;
import org.hibernate.ogm.datastore.spi.DatastoreConfiguration;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.dialect.impl.GridDialects;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.options.navigation.GlobalContext;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.ogm.utils.GridDialectTestHelper;
import org.hibernate.ogm.utils.GridDialectTestHelperType;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.HashMapTestHelper;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;

public class TestHelper {
    private static final Log log = LoggerFactory.make();
    private static final String TX_CONTROL_CLASS_NAME = "com.arjuna.ats.arjuna.coordinator.TxControl";
    private static final GridDialectTestHelperType GRID_DIALECT_TEST_HELPER_TYPE = TestHelper.determineGridDialectTestHelperType();
    private static final GridDialectTestHelper HELPER = TestHelper.instantiate(GRID_DIALECT_TEST_HELPER_TYPE.loadGridDialectTestHelperClass());
    private static final GridDialectType GRID_DIALECT_TYPE = TestHelper.determineGridDialectType();

    private TestHelper() {
    }

    private static GridDialectTestHelperType determineGridDialectTestHelperType() {
        for (GridDialectTestHelperType gridType : GridDialectTestHelperType.values()) {
            Class<GridDialectTestHelper> testDialectClass = gridType.loadGridDialectTestHelperClass();
            if (testDialectClass == null) continue;
            return gridType;
        }
        return GridDialectTestHelperType.HASHMAP;
    }

    private static GridDialectType determineGridDialectType() {
        Class<? extends GridDialect> gridDialectClass = TestHelper.getCurrentGridDialectClass();
        for (GridDialectType gridDialectType : GridDialectType.values()) {
            Class<? extends GridDialect> testDialectClass = gridDialectType.loadGridDialectClass();
            if (testDialectClass == null || !testDialectClass.isAssignableFrom(gridDialectClass)) continue;
            return gridDialectType;
        }
        return GridDialectType.HASHMAP;
    }

    private static GridDialectTestHelper instantiate(Class<GridDialectTestHelper> testableGridDialectClass) {
        if (testableGridDialectClass == null) {
            return new HashMapTestHelper();
        }
        try {
            GridDialectTestHelper testableGridDialect = testableGridDialectClass.newInstance();
            log.debugf("Using TestGridDialect %s", testableGridDialectClass);
            return testableGridDialect;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static long getNumberOfEntities(EntityManager em) {
        return TestHelper.getNumberOfEntities((Session)em.unwrap(Session.class));
    }

    public static GridDialectType getCurrentDialectType() {
        return GRID_DIALECT_TYPE;
    }

    public static DatastoreProviderType getCurrentDatastoreProviderType() {
        return DatastoreProviderTypeHolder.INSTANCE;
    }

    public static Class<? extends GridDialect> getCurrentGridDialectClass() {
        return GridDialectClassHolder.INSTANCE;
    }

    public static GridDialect getCurrentGridDialect(DatastoreProvider datastoreProvider) {
        return HELPER.getGridDialect(datastoreProvider);
    }

    public static <D extends DatastoreConfiguration<?>> Class<D> getCurrentDatastoreConfiguration() {
        Class<? extends DatastoreConfiguration<?>> configurationType = HELPER.getDatastoreConfigurationType();
        return configurationType;
    }

    public static long getNumberOfEntities(Session session) {
        return HELPER.getNumberOfEntities(session);
    }

    public static long getNumberOfEntities(SessionFactory sessionFactory) {
        return HELPER.getNumberOfEntities(sessionFactory);
    }

    public static Map<String, Object> extractEntityTuple(Session session, EntityKey key) {
        return HELPER.extractEntityTuple(session, key);
    }

    public static long getNumberOfAssociations(Session session) {
        return HELPER.getNumberOfAssociations(session);
    }

    public static long getNumberOfAssociations(SessionFactory sessionFactory) {
        return HELPER.getNumberOfAssociations(sessionFactory);
    }

    public static long getNumberOfAssociations(SessionFactory sessionFactory, AssociationStorageType type) {
        return HELPER.getNumberOfAssociations(sessionFactory, type);
    }

    public static boolean backendSupportsTransactions() {
        return HELPER.backendSupportsTransactions();
    }

    public static <T> T get(Session session, Class<T> clazz, Serializable id) {
        return (T)session.get(clazz, id);
    }

    public static void dropSchemaAndDatabase(Session session) {
        if (session != null) {
            TestHelper.dropSchemaAndDatabase(session.getSessionFactory());
        }
    }

    public static void dropSchemaAndDatabase(EntityManagerFactory emf) {
        if (emf != null) {
            TestHelper.dropSchemaAndDatabase((SessionFactory)((HibernateEntityManagerFactory)emf).getSessionFactory());
        }
    }

    public static void dropSchemaAndDatabase(SessionFactory sessionFactory) {
        if (sessionFactory != null && !sessionFactory.isClosed()) {
            try {
                HELPER.dropSchemaAndDatabase(sessionFactory);
            }
            catch (Exception e) {
                log.warn((Object)"Exception while dropping schema and database in test", (Throwable)e);
            }
        }
    }

    public static void checkCleanCache(SessionFactory sessionFactory) {
        ((LongAssert)Assertions.assertThat((long)TestHelper.getNumberOfEntities(sessionFactory)).as("Entity cache should be empty")).isEqualTo(0L);
        ((LongAssert)Assertions.assertThat((long)TestHelper.getNumberOfAssociations(sessionFactory)).as("Association cache should be empty")).isEqualTo(0L);
    }

    public static Map<String, String> getDefaultTestSettings() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("hibernate.ogm.enabled", "true");
        settings.put("hibernate.hbm2ddl.auto", "none");
        settings.put("hibernate.search.default.directory_provider", "ram");
        Map<String, String> environmentProperties = HELPER.getEnvironmentProperties();
        if (environmentProperties != null) {
            settings.putAll(environmentProperties);
        }
        return settings;
    }

    public static StandardServiceRegistry getDefaultTestStandardServiceRegistry(Map<String, Object> settings) {
        StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder();
        for (Map.Entry<String, String> entry : TestHelper.getDefaultTestSettings().entrySet()) {
            registryBuilder.applySetting(entry.getKey(), (Object)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : settings.entrySet()) {
            registryBuilder.applySetting(entry.getKey(), entry.getValue());
        }
        return registryBuilder.build();
    }

    private static MetadataSources getMetadataSources(Class<?> ... entityTypes) {
        MetadataSources sources = new MetadataSources();
        for (Class<?> entityType : entityTypes) {
            sources.addAnnotatedClass(entityType);
        }
        return sources;
    }

    private static Metadata getDefaultTestMetadata(Map<String, Object> settings, Class<?> ... entityTypes) {
        StandardServiceRegistry serviceRegistry = TestHelper.getDefaultTestStandardServiceRegistry(settings);
        MetadataSources sources = TestHelper.getMetadataSources(entityTypes);
        return sources.getMetadataBuilder(serviceRegistry).build();
    }

    public static OgmSessionFactory getDefaultTestSessionFactory(Class<?> ... entityTypes) {
        return TestHelper.getDefaultTestSessionFactory(Collections.emptyMap(), entityTypes);
    }

    public static OgmSessionFactory getDefaultTestSessionFactory(Map<String, Object> settings, Class<?> ... entityTypes) {
        return ((OgmSessionFactoryBuilder)TestHelper.getDefaultTestMetadata(settings, entityTypes).getSessionFactoryBuilder().unwrap(OgmSessionFactoryBuilder.class)).build();
    }

    public static <D extends DatastoreConfiguration<G>, G extends GlobalContext<?, ?>> G configureOptionsFor(Map<String, Object> settings, Class<D> datastoreType) {
        ConfigurableImpl configurable = new ConfigurableImpl();
        settings.put("hibernate.ogm.options.context", configurable.getContext());
        return (G)configurable.configureOptionsFor(datastoreType);
    }

    static <T> Class<T> loadClass(String className) {
        try {
            return Class.forName(className, true, TestHelper.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return Class.forName(className, false, contextClassLoader);
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static {
        Class txControlClass = TestHelper.loadClass(TX_CONTROL_CLASS_NAME);
        if (txControlClass != null) {
            try {
                Method timeoutMethod = txControlClass.getMethod("setDefaultTimeout", Integer.TYPE);
                timeoutMethod.invoke(null, 7200);
            }
            catch (NoSuchMethodException e) {
                log.error((Object)"Found TxControl class, but unable to set timeout");
            }
            catch (IllegalAccessException e) {
                log.error((Object)"Found TxControl class, but unable to set timeout");
            }
            catch (InvocationTargetException e) {
                log.error((Object)"Found TxControl class, but unable to set timeout");
            }
            TxControl.setDefaultTimeout((int)7200);
        }
    }

    private static class DatastoreProviderTypeHolder {
        private static final DatastoreProviderType INSTANCE = DatastoreProviderTypeHolder.getDatastoreProvider();

        private DatastoreProviderTypeHolder() {
        }

        private static DatastoreProviderType getDatastoreProvider() {
            StandardServiceRegistry isolatedServiceRegistry = TestHelper.getDefaultTestStandardServiceRegistry(Collections.emptyMap());
            Object datastoreProviderProperty = ((ConfigurationService)isolatedServiceRegistry.getService(ConfigurationService.class)).getSettings().get("hibernate.ogm.datastore.provider");
            StandardServiceRegistryBuilder.destroy((ServiceRegistry)isolatedServiceRegistry);
            if (datastoreProviderProperty == null) {
                return null;
            }
            String value = datastoreProviderProperty.toString();
            DatastoreProviderType byShortName = DatastoreProviderTypeHolder.findByShortName(value);
            if (byShortName != null) {
                return byShortName;
            }
            DatastoreProviderType byClassName = DatastoreProviderTypeHolder.findByExactClassName(value);
            if (byClassName != null) {
                return byClassName;
            }
            DatastoreProviderType byAssignableType = DatastoreProviderTypeHolder.findByAssignableType(value);
            if (byAssignableType != null) {
                return byAssignableType;
            }
            throw new IllegalStateException("Could not determine datastore provider from value: " + datastoreProviderProperty);
        }

        private static DatastoreProviderType findByShortName(String value) {
            if (DatastoreProviderType.isShortName((String)value)) {
                return DatastoreProviderType.byShortName((String)value);
            }
            return null;
        }

        private static DatastoreProviderType findByExactClassName(String value) {
            for (DatastoreProviderType provider : DatastoreProviderType.values()) {
                if (!provider.getDatastoreProviderClassName().equals(value)) continue;
                return provider;
            }
            return null;
        }

        private static DatastoreProviderType findByAssignableType(String value) {
            Class configuredProviderClass = TestHelper.loadClass(value);
            if (configuredProviderClass == null) {
                return null;
            }
            for (DatastoreProviderType provider : DatastoreProviderType.values()) {
                Class availableProviderClass = TestHelper.loadClass(provider.getDatastoreProviderClassName());
                if (availableProviderClass == null || !availableProviderClass.isAssignableFrom(configuredProviderClass)) continue;
                return provider;
            }
            return null;
        }
    }

    private static class GridDialectClassHolder {
        private static final Class<? extends GridDialect> INSTANCE = GridDialectClassHolder.getGridDialectClass();

        private GridDialectClassHolder() {
        }

        private static Class<? extends GridDialect> getGridDialectClass() {
            StandardServiceRegistry isolatedServiceRegistry = TestHelper.getDefaultTestStandardServiceRegistry(Collections.emptyMap());
            Service gridDialect = isolatedServiceRegistry.getService(GridDialect.class);
            Class gridDialectClass = GridDialects.getWrappedDialect((GridDialect)((GridDialect)gridDialect));
            StandardServiceRegistryBuilder.destroy((ServiceRegistry)isolatedServiceRegistry);
            return gridDialectClass;
        }
    }
}

