/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.utils.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.TransactionManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.ogm.jpa.impl.OgmEntityManagerFactory;
import org.hibernate.ogm.utils.TestEntities;
import org.hibernate.ogm.utils.TestEntityManagerFactory;
import org.hibernate.ogm.utils.TestEntityManagerFactoryConfiguration;
import org.hibernate.ogm.utils.jpa.GetterPersistenceUnitInfo;
import org.hibernate.ogm.utils.jpa.OgmJpaTestRunner;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.junit.runner.RunWith;

@RunWith(value=OgmJpaTestRunner.class)
public abstract class OgmJpaTestCase {
    @TestEntityManagerFactory
    private EntityManagerFactory factory;

    public EntityManagerFactory getFactory() {
        return this.factory;
    }

    @TestEntities
    private Class<?>[] getTestEntities() {
        return this.getAnnotatedClasses();
    }

    protected abstract Class<?>[] getAnnotatedClasses();

    @TestEntityManagerFactoryConfiguration
    private void modifyConfiguration(GetterPersistenceUnitInfo info) {
        this.configure(info);
    }

    protected void configure(GetterPersistenceUnitInfo info) {
    }

    protected TransactionManager getTransactionManager(EntityManagerFactory factory) {
        return ((JtaPlatform)this.getServiceRegistry().getService(JtaPlatform.class)).retrieveTransactionManager();
    }

    protected ServiceRegistryImplementor getServiceRegistry() {
        OgmEntityManagerFactory emFactory = (OgmEntityManagerFactory)this.getFactory();
        SessionFactoryImplementor sessionFactory = emFactory.getSessionFactory();
        ServiceRegistryImplementor serviceRegistry = sessionFactory.getServiceRegistry();
        return serviceRegistry;
    }

    protected void removeEntities() throws Exception {
        EntityManager em = this.getFactory().createEntityManager();
        em.getTransaction().begin();
        for (Class<?> each : this.getAnnotatedClasses()) {
            List entities = em.createQuery("FROM " + each.getSimpleName()).getResultList();
            for (Object object : entities) {
                em.remove(object);
            }
        }
        em.getTransaction().commit();
        em.close();
    }
}

