/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.utils.jpa;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.transaction.TransactionManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.jpa.HibernateEntityManagerFactory;
import org.hibernate.ogm.exception.impl.Exceptions;
import org.hibernate.ogm.jpa.HibernateOgmPersistence;
import org.hibernate.ogm.utils.SkippableTestRunner;
import org.hibernate.ogm.utils.TestEntities;
import org.hibernate.ogm.utils.TestEntityManagerFactory;
import org.hibernate.ogm.utils.TestEntityManagerFactoryConfiguration;
import org.hibernate.ogm.utils.TestHelper;
import org.hibernate.ogm.utils.jpa.GetterPersistenceUnitInfo;
import org.hibernate.ogm.utils.jpa.NoopDatasource;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;

public class OgmJpaTestRunner
extends SkippableTestRunner {
    private final Set<Field> testScopedFactoryFields = OgmJpaTestRunner.getTestFactoryFields(this.getTestClass(), TestEntityManagerFactory.Scope.TEST_CLASS);
    private final Set<Field> testMethodScopedFactoryFields = OgmJpaTestRunner.getTestFactoryFields(this.getTestClass(), TestEntityManagerFactory.Scope.TEST_METHOD);
    private EntityManagerFactory testScopedEntityManagerFactory;
    private EntityManagerFactory testMethodScopedEntityManagerFactory;

    public OgmJpaTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    private static Set<Field> getTestFactoryFields(TestClass testClass, TestEntityManagerFactory.Scope scope) {
        HashSet<Field> testFactoryFields = new HashSet<Field>();
        for (FrameworkField frameworkField : testClass.getAnnotatedFields(TestEntityManagerFactory.class)) {
            Field field = frameworkField.getField();
            if (scope != field.getAnnotation(TestEntityManagerFactory.class).scope()) continue;
            field.setAccessible(true);
            testFactoryFields.add(field);
        }
        return testFactoryFields;
    }

    @Override
    public void run(RunNotifier notifier) {
        if (this.isTestScopedEntityManagerFactoryRequired()) {
            this.testScopedEntityManagerFactory = this.buildEntityManagerFactory();
            this.injectEntityManagerFactory(null, this.testScopedFactoryFields, this.testScopedEntityManagerFactory);
        }
        try {
            super.run(notifier);
        }
        finally {
            if (this.testScopedEntityManagerFactory != null) {
                this.cleanUpPendingTransactionIfRequired(this.testScopedEntityManagerFactory);
                TestHelper.dropSchemaAndDatabase(this.testScopedEntityManagerFactory);
                this.testScopedEntityManagerFactory.close();
            }
        }
    }

    @Override
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        if (this.isTestMethodScopedEntityManagerFactoryRequired(method)) {
            this.testMethodScopedEntityManagerFactory = this.buildEntityManagerFactory();
        }
        try {
            super.runChild(method, notifier);
        }
        finally {
            if (this.testMethodScopedEntityManagerFactory != null) {
                this.cleanUpPendingTransactionIfRequired(this.testMethodScopedEntityManagerFactory);
                this.testMethodScopedEntityManagerFactory.close();
            }
        }
    }

    private boolean isTestScopedEntityManagerFactoryRequired() {
        return !this.isTestClassSkipped() && !this.areAllTestMethodsSkipped();
    }

    private boolean isTestMethodScopedEntityManagerFactoryRequired(FrameworkMethod method) {
        return !this.testMethodScopedFactoryFields.isEmpty() && !super.isTestMethodSkipped(method);
    }

    private void cleanUpPendingTransactionIfRequired(EntityManagerFactory entityManagerFactory) {
        SessionFactoryImplementor sessionFactory = ((HibernateEntityManagerFactory)entityManagerFactory).getSessionFactory();
        TransactionManager transactionManager = ((JtaPlatform)sessionFactory.getServiceRegistry().getService(JtaPlatform.class)).retrieveTransactionManager();
        try {
            if (transactionManager != null && transactionManager.getStatus() == 0) {
                transactionManager.rollback();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while cleaning up the pending transactions", e);
        }
    }

    protected EntityManagerFactory buildEntityManagerFactory() {
        try {
            GetterPersistenceUnitInfo info = new GetterPersistenceUnitInfo();
            info.setClassLoader(Thread.currentThread().getContextClassLoader());
            info.setExcludeUnlistedClasses(true);
            info.setJtaDataSource(new NoopDatasource());
            ArrayList<String> classNames = new ArrayList<String>();
            for (Class<?> clazz : this.getConfiguredEntityTypes()) {
                classNames.add(clazz.getName());
            }
            info.setManagedClassNames(classNames);
            info.setNonJtaDataSource(null);
            info.setPersistenceProviderClassName(HibernateOgmPersistence.class.getName());
            info.setPersistenceUnitName("default");
            URL persistenceUnitRootUrl = new File("").toURI().toURL();
            info.setPersistenceUnitRootUrl(persistenceUnitRootUrl);
            info.setPersistenceXMLSchemaVersion("2.0");
            info.setProperties(new Properties());
            info.setSharedCacheMode(SharedCacheMode.ENABLE_SELECTIVE);
            info.setTransactionType(PersistenceUnitTransactionType.RESOURCE_LOCAL);
            info.setValidationMode(ValidationMode.AUTO);
            for (Map.Entry<String, String> entry : TestHelper.getDefaultTestSettings().entrySet()) {
                info.getProperties().setProperty(entry.getKey(), entry.getValue());
            }
            this.applyTestSpecificSettings(info);
            return new HibernateOgmPersistence().createContainerEntityManagerFactory((PersistenceUnitInfo)info, Collections.EMPTY_MAP);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to build the entity manager factory", e);
        }
    }

    private Class<?>[] getConfiguredEntityTypes() {
        Iterator iterator = this.getTestClass().getAnnotatedMethods(TestEntities.class).iterator();
        if (iterator.hasNext()) {
            FrameworkMethod frameworkMethod = (FrameworkMethod)iterator.next();
            Class<?>[] entityTypes = this.invokeTestEntitiesMethod(frameworkMethod);
            if (entityTypes == null || entityTypes.length == 0) {
                throw new IllegalArgumentException("Define at least a single annotated entity");
            }
            return entityTypes;
        }
        throw new IllegalStateException("The entities of the test must be retrievable via a parameterless method which is annotated with " + TestEntities.class.getSimpleName() + " and returns Class<?>[].");
    }

    private Class<?>[] invokeTestEntitiesMethod(FrameworkMethod frameworkMethod) {
        Method method = frameworkMethod.getMethod();
        method.setAccessible(true);
        if (method.getReturnType() != Class[].class || method.getParameterTypes().length > 0) {
            throw new IllegalStateException("Method annotated with " + TestEntities.class.getSimpleName() + " must have no parameters and must return Class<?>[].");
        }
        Class[] entityTypes = null;
        try {
            entityTypes = (Class[])method.invoke(super.createTest(), new Object[0]);
        }
        catch (Exception e) {
            Exceptions.sneakyThrow((Exception)e);
        }
        return entityTypes;
    }

    private void applyTestSpecificSettings(GetterPersistenceUnitInfo info) {
        try {
            for (FrameworkMethod frameworkMethod : this.getTestClass().getAnnotatedMethods(TestEntityManagerFactoryConfiguration.class)) {
                Method method = frameworkMethod.getMethod();
                method.setAccessible(true);
                method.invoke(super.createTest(), info);
            }
        }
        catch (Exception e) {
            Exceptions.sneakyThrow((Exception)e);
        }
    }

    protected Object createTest() throws Exception {
        Object test = super.createTest();
        if (!this.testScopedFactoryFields.isEmpty()) {
            this.injectEntityManagerFactory(test, this.testScopedFactoryFields, this.testScopedEntityManagerFactory);
        }
        if (!this.testMethodScopedFactoryFields.isEmpty()) {
            this.injectEntityManagerFactory(test, this.testMethodScopedFactoryFields, this.testMethodScopedEntityManagerFactory);
        }
        return test;
    }

    private void injectEntityManagerFactory(Object test, Iterable<Field> fields, EntityManagerFactory sessionFactory) {
        for (Field field : fields) {
            try {
                if ((test != null || !Modifier.isStatic(field.getModifiers())) && (test == null || Modifier.isStatic(field.getModifiers()))) continue;
                field.set(test, sessionFactory);
            }
            catch (Exception e) {
                throw new RuntimeException("Can't inject entity manager factory into field " + field);
            }
        }
    }
}

