/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.utils.jpa;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.transaction.TransactionManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.jpa.HibernateEntityManagerFactory;
import org.hibernate.ogm.jpa.HibernateOgmPersistence;
import org.hibernate.ogm.jpa.impl.OgmEntityManagerFactory;
import org.hibernate.ogm.utils.SkippableTestRunner;
import org.hibernate.ogm.utils.TestHelper;
import org.hibernate.ogm.utils.jpa.GetterPersistenceUnitInfo;
import org.hibernate.ogm.utils.jpa.NoopDatasource;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;

@RunWith(value=SkippableTestRunner.class)
public abstract class SingleJpaTestCase {
    private EntityManagerFactory factory;
    private TransactionManager transactionManager;

    public EntityManagerFactory getFactory() {
        return this.factory;
    }

    public abstract Class<?>[] getEntities();

    @Before
    public void createFactory() throws Throwable {
        GetterPersistenceUnitInfo info = new GetterPersistenceUnitInfo();
        info.setClassLoader(Thread.currentThread().getContextClassLoader());
        info.setExcludeUnlistedClasses(true);
        info.setJtaDataSource(new NoopDatasource());
        ArrayList<String> classNames = new ArrayList<String>();
        for (Class<?> clazz : this.getEntities()) {
            classNames.add(clazz.getName());
        }
        info.setManagedClassNames(classNames);
        info.setNonJtaDataSource(null);
        info.setPersistenceProviderClassName(HibernateOgmPersistence.class.getName());
        info.setPersistenceUnitName("default");
        URL persistenceUnitRootUrl = new File("").toURI().toURL();
        info.setPersistenceUnitRootUrl(persistenceUnitRootUrl);
        info.setPersistenceXMLSchemaVersion("2.0");
        info.setProperties(new Properties());
        info.setSharedCacheMode(SharedCacheMode.ENABLE_SELECTIVE);
        info.setTransactionType(PersistenceUnitTransactionType.RESOURCE_LOCAL);
        info.setValidationMode(ValidationMode.AUTO);
        for (Map.Entry<String, String> entry : TestHelper.getDefaultTestSettings().entrySet()) {
            info.getProperties().setProperty(entry.getKey(), entry.getValue());
        }
        this.refineInfo(info);
        this.factory = new HibernateOgmPersistence().createContainerEntityManagerFactory((PersistenceUnitInfo)info, Collections.EMPTY_MAP);
        this.transactionManager = SingleJpaTestCase.extractJBossTransactionManager(this.factory);
    }

    protected void refineInfo(GetterPersistenceUnitInfo info) {
    }

    public TransactionManager getTransactionManager() throws Exception {
        return this.transactionManager;
    }

    private static TransactionManager extractJBossTransactionManager(EntityManagerFactory factory) {
        SessionFactoryImplementor sessionFactory = ((HibernateEntityManagerFactory)factory).getSessionFactory();
        return ((JtaPlatform)sessionFactory.getServiceRegistry().getService(JtaPlatform.class)).retrieveTransactionManager();
    }

    protected ServiceRegistryImplementor getServiceRegistry() {
        OgmEntityManagerFactory emFactory = (OgmEntityManagerFactory)this.getFactory();
        SessionFactoryImplementor sessionFactory = emFactory.getSessionFactory();
        ServiceRegistryImplementor serviceRegistry = sessionFactory.getServiceRegistry();
        return serviceRegistry;
    }

    @After
    public void closeFactory() throws Exception {
        if (this.transactionManager != null && this.transactionManager.getStatus() == 0) {
            this.transactionManager.rollback();
        }
        if (this.factory != null) {
            if (this.factory.isOpen()) {
                TestHelper.dropSchemaAndDatabase(this.factory);
                this.factory.close();
                this.factory = null;
            } else {
                this.factory = null;
            }
        }
    }
}

