/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.document.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.ogm.datastore.document.association.impl.DocumentHelpers;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationType;

public class MapAssociationRowsHelpers {
    private static final String EMBEDDABLE_COLUMN_PREFIX = ".value.";
    private static final String PATH_SEPARATOR = ".";

    public static Collection<?> getRows(Object toManyValue, AssociationKey associationKey) {
        Object oneToOneValue;
        Collection<Object> rows = null;
        if (associationKey.getMetadata().getAssociationType() == AssociationType.ONE_TO_ONE && (oneToOneValue = toManyValue) != null) {
            rows = Collections.singletonList(oneToOneValue);
        }
        if (toManyValue instanceof Collection) {
            rows = (List<Object>)toManyValue;
        } else if (toManyValue instanceof Map) {
            rows = MapAssociationRowsHelpers.getRowsFromMapAssociation(associationKey, (Map)toManyValue);
        }
        return rows != null ? rows : Collections.emptyList();
    }

    private static Collection<Map<String, Object>> getRowsFromMapAssociation(AssociationKey associationKey, Map<String, Object> value) {
        String rowKeyIndexColumn = associationKey.getMetadata().getRowKeyIndexColumnNames()[0];
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        String[] associationKeyColumns = associationKey.getMetadata().getAssociatedEntityKeyMetadata().getAssociationKeyColumns();
        String prefix = DocumentHelpers.getColumnSharedPrefix(associationKeyColumns);
        prefix = prefix == null ? "" : prefix + PATH_SEPARATOR;
        String embeddedValueColumnPrefix = associationKey.getMetadata().getCollectionRole() + EMBEDDABLE_COLUMN_PREFIX;
        for (String rowKey : value.keySet()) {
            Object mapRow = value.get(rowKey);
            HashMap<String, Object> row = new HashMap<String, Object>();
            MapAssociationRowsHelpers.set(row, rowKeyIndexColumn, rowKey);
            if (mapRow instanceof Map) {
                for (String column : associationKey.getMetadata().getAssociatedEntityKeyMetadata().getAssociationKeyColumns()) {
                    if (column.startsWith(embeddedValueColumnPrefix)) {
                        MapAssociationRowsHelpers.set(row, column.substring(associationKey.getMetadata().getCollectionRole().length() + 1), ((Map)mapRow).get(column.substring(embeddedValueColumnPrefix.length())));
                        continue;
                    }
                    MapAssociationRowsHelpers.set(row, column.substring(prefix.length()), ((Map)mapRow).get(column.substring(prefix.length())));
                }
            } else {
                MapAssociationRowsHelpers.set(row, associationKey.getMetadata().getAssociatedEntityKeyMetadata().getAssociationKeyColumns()[0], mapRow);
            }
            rows.add(row);
        }
        return rows;
    }

    public static void set(Map<String, Object> target, String name, Object value) {
        if (value instanceof Map) {
            MapAssociationRowsHelpers.setMapValue(target, name, (Map)value);
        } else {
            target.put(name, value);
        }
    }

    private static void setMapValue(Map<String, Object> target, String name, Map<String, Object> value) {
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            MapAssociationRowsHelpers.set(target, name + PATH_SEPARATOR + entry.getKey(), entry.getValue());
        }
    }
}

