/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.map.impl;

import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.datastore.map.impl.MapTupleSnapshot;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;

public final class MapAssociationSnapshot
implements AssociationSnapshot {
    private final Map<RowKey, Map<String, Object>> associationMap;

    public MapAssociationSnapshot(Map<RowKey, Map<String, Object>> associationMap) {
        this.associationMap = associationMap;
    }

    @Override
    public Tuple get(RowKey column) {
        Map<String, Object> rawResult = this.associationMap.get(column);
        return rawResult != null ? new Tuple(new MapTupleSnapshot(rawResult), Tuple.SnapshotType.UPDATE) : null;
    }

    @Override
    public boolean containsKey(RowKey column) {
        return this.associationMap.containsKey(column);
    }

    @Override
    public int size() {
        return this.associationMap.size();
    }

    public Set<RowKey> getRowKeys() {
        return this.associationMap.keySet();
    }

    public Map<RowKey, Map<String, Object>> getUnderlyingMap() {
        return this.associationMap;
    }
}

